/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <kapplication.h>
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>

#include "kbfxconfigapp.h"

static const char description[] = I18N_NOOP("KBFX Configuration Utility");
static const char version[] = VERSION;

int main(int argc, char **argv)
{
  KAboutData about("kbfxconfigapp",
                   I18N_NOOP("kbfxconfigapp"),
                   version,
                   description,
                   KAboutData::License_GPL,
                   "(C) 2006 PhobosK",
                   0,
                   0,
                   "phobosk@mail.kbfx.org");

  about.addAuthor("PhobosK", 0, "phobosk@mail.kbfx.org");

  static KCmdLineOptions options[] =
  {
    {"install <theme URL>", I18N_NOOP("Install KBFX theme from <URL>"), 0},
    { "prepare <folder URL>", I18N_NOOP("Prepare KBFX theme from folder <URL>"), 0 },
    {0, 0, 0}
  };

  KCmdLineArgs::reset();
  KCmdLineArgs::init( argc, argv, &about );
  KCmdLineArgs::addCmdLineOptions( options );
  KUniqueApplication::addCmdLineOptions();
    

//  KApplication app;
  KUniqueApplication app;
  KbfxConfigApp *mainWin = 0;

  mainWin = new KbfxConfigApp();
  app.setMainWidget( mainWin );
//  mainWin->show();

  /* mainWin has WDestructiveClose flag by default, so it will delete itself */
  return app.exec();
}
