/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"

#include "kbfxtooltip.h"
#include "kbfxconfig.h"
#include <qpixmap.h>
#include <qimage.h>
#include <qcursor.h>
#include <qpainter.h>
#include <ktip.h>
#include "../imagesource/tooltipmask.xpm"
#include "../imagesource/tooltip_dudebox.xpm"
#include "../imagesource/tooltiplogo.xpm"
#include "../imagesource/window.xpm"


KbfxToolTip::KbfxToolTip (QWidget * parent, const char *name, WFlags fl):
QWidget (parent, name,
	 fl | WStyle_Customize | WRepaintNoErase | WStyle_NoBorder |
	 WDestructiveClose | Qt::WPaintDesktop | Qt::WType_Popup | Qt::
	 WPaintClever | Qt::WNoAutoErase | Qt::WResizeNoErase | Qt::
	 WStaticContents | Qt::WNoAutoErase)
{

  ConfigInit ().read ();
  _animate = ConfigInit ().m_ToolTipAnimation;
  setUserImage ();
  setBoundBox ();
  composeDudeBox ();
  setBackground (QPixmap ());
  setWindow (QPixmap ());
  setAnimationImage (ConfigInit ().m_ToolTipAvatar);

  _hide_timer = new QTimer (this);
  _update_timer = new QTimer (this);
  _move_timer = new QTimer (this);

  connect (_hide_timer, SIGNAL (timeout ()), this, SLOT (hide ()));
  connect (_hide_timer, SIGNAL (timeout ()), _agent, SLOT (hide ()));
  connect (_update_timer, SIGNAL (timeout ()), this, SLOT (logoMove ()));
  connect (_move_timer, SIGNAL (timeout ()), this, SLOT (moveOnScreen ()));

  QCursor kbfxCursor;
  kbfxCursor.setShape (Qt::PointingHandCursor);
  this->setCursor ((const QCursor) kbfxCursor);

}

void
KbfxToolTip::setWindow (QPixmap win)
{
  QImage m_win_img;

  (win.isNull ())?
    m_win_img = QImage (window_xpm) : m_win_img = win.convertToImage ();

  m_win_img = m_win_img.smoothScale (_bg.width (), 13);
//  _window = new QLabel (this, "", Qt::WStaticContents | Qt::WNoAutoErase);
  _window = new QLabel (this, "");
  _window->resize (_bg.width (), 13);
  _window->setBackgroundPixmap (m_win_img);
  if (_animate)
    _window->show ();
  else
    _window->hide ();
}

void
KbfxToolTip::setAnimationImage (QString path)
{
  if (path == "")
    {
      KIconLoader *iconload = KGlobal::iconLoader ();
      path =
	iconload->iconPath (QString ("butterfly"), KIcon::Desktop, false);
    }
/*
  _agent = new QLabel (this, "",
		       Qt::WStaticContents |
		       Qt::WNoAutoErase | Qt::WPaintDesktop);
*/
  _agent = new QLabel(this,"");
  _agent->resize (100, 100);

  _agent_anim = new QMovie (path);
  QPixmap agent_mask = _agent_anim->framePixmap ();
  _agent->setBackgroundPixmap (agent_mask);
  if (agent_mask.mask ())
    _agent->setMask (*agent_mask.mask ());
  _agent->repaint ();
//FIXME:Need to remover Hard Coded Values
  _agent->move (200, 0);

  if (_animate)
    _agent->show ();
  else
    _agent->close ();
}


void
KbfxToolTip::setBackground (QPixmap bg)
{

  (bg.isNull ())? _bg = QImage (tooltipmask) : _bg = bg.convertToImage ();
//animation check : Auto streatch

  if (_animate)
    {
      QImage m_tmp = _bg;
      _bg = m_tmp.smoothScale (_bg.width () + 100, _bg.height ());

    }

  this->setBackgroundPixmap (_bg);

  QPixmap m_tmp (_bg);
  if (m_tmp.mask ())
    this->setMask ((*m_tmp.mask ()));
  this->resize (_bg.width (), _bg.height ());
  _maxW = _bg.width ();
}

void
KbfxToolTip::setStartPos (int _x_, int _y_)
{
  _x = _x_;
 _y = _y_;
  _logo_move_x = 100;
  if (_animate)
    {
      _logo_move_x = 0;
      _hide_timer->start (10000, TRUE);
      _move_timer->start (_agent_anim->speed (), FALSE);
      _update_timer->start (2, FALSE);
    }

  move (_x, _y);
}

void
KbfxToolTip::logoMove ()
{
  if (_logo_move_x < _bg.width () - 68)
    {
      _logo_move_x += 1;
      _window->repaint ();
      QImage logo (tooltiplogo);
      QPainter p;
      p.begin (_window);
      p.drawPixmap (QRect (_logo_move_x, 0, logo.width (), logo.height ()),
		    QPixmap (QImage (tooltiplogo)));
      p.end ();
    }
   else
   {
      QImage logo (tooltiplogo);
      QPainter p;
      p.begin (_window);
      p.drawPixmap (QRect (_bg.width () - 68, 0, logo.width (), logo.height ()),
		    QPixmap (QImage (tooltiplogo)));
      p.end ();


   }
 
  QPixmap agent_mask = _agent_anim->framePixmap ();
  _agent->setBackgroundPixmap (agent_mask);
  if (agent_mask.mask ())
    _agent->setMask (*agent_mask.mask ());
  _agent->repaint ();
}

void
KbfxToolTip::moveOnScreen ()
{
  if (this->width () < _maxW + _agent->width () + 10)
    {
      // this->resize (_width++, this->height ());
    }

}

void
KbfxToolTip::setAnimated (bool b)
{
  _animate = b;
}


void
KbfxToolTip::setLabelText (QString str)
{

  _label_text = str;

}

void
KbfxToolTip::setHeadingText (QString str)
{


  _heading_text = str;


}

void
KbfxToolTip::setVersionText (QString str)
{
  _version_text = str;
}

void
KbfxToolTip::setMovingLogo (QPixmap logo)
{
  logo = logo;			//do some thing later

}








KbfxToolTip::~KbfxToolTip ()
{

  delete _hide_timer;
  delete _move_timer;
  delete _update_timer;
  delete _window;
  delete _agent;
  delete _agent_anim;



}

void
KbfxToolTip::hideToolTip ()
{
  _move_timer->stop ();
  _hide_timer->stop ();

  _agent->close ();
  this->hide ();
  this->close ();
}


void
KbfxToolTip::setUserImage ()
{
  KUser *user = new KUser ();
  QString logInName (user->loginName ());

//  QImage userimage ( locate("data", user->homeDir () + "/.face.icon"));
  QImage userimage ( ConfigInit().m_SpinxDudeImage);
  userimage = userimage.smoothScale (48, 48);
  if(userimage.isNull())
	qDebug("kbfxtooltip.cpp: setUserImage()  : userimage is null");
  _dude = QPixmap (userimage);
}

void
KbfxToolTip::setBoundBox ()
{

  _dude_box = QPixmap (tooltip_dudebox);

}



void
KbfxToolTip::composeDudeBox ()
{

}

void
KbfxToolTip::paintEvent (QPaintEvent * pe)
{

  const QRect r = pe->rect ();
  QFont *let = new QFont ();

  KTipDatabase *tips = new KTipDatabase (QString ("/home/siraj/tips"));
  QPainter p;
  p.begin (this);
  p.setBackgroundMode (Qt::TransparentMode);
//  p.setRasterOp(Qt::XorROP);
  p.drawPixmap (QRect (7, 16, _dude_box.width (), _dude_box.height ()),
		_dude_box);
  int _paddingX = ((_dude_box.height () - _dude.height ()) / 2) + 16;
  p.drawPixmap (QRect
		(_paddingX - (55 - 48), _paddingX, _dude.width (),
		 _dude.height ()), _dude);

  if (_animate)
    {
    }
  else
    {
      QImage logo (tooltiplogo);
      p.drawPixmap (QRect (126, 0, logo.width (), logo.height ()),
		    QPixmap (QImage (tooltiplogo)));
    }

  let->setBold (TRUE);
  let->setPointSize (10);
  p.setFont (*let);
  p.setPen (QColor (61, 94, 129));
  p.drawText (_dude_box.width () + 15, 30, "KBFX");

  p.setPen (QColor (0, 0, 0));
  let->setBold (FALSE);
  let->setPointSize (8);
  p.setFont (*let);
  p.drawText ((_animate) ? _dude_box.width () + 50 : _dude_box.width () + 4,
	      _dude_box.height () + 30, QString("Version ").append(VERSION));

  let->setBold (TRUE);
  let->setPointSize (8);
  p.setFont (*let);


  p.drawText (_dude_box.width () + 15, 43, tr (ConfigInit ().m_ToolTipText));
  tips->nextTip ();
  p.end ();



}
