/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef VISTALISTBOX_H
#define VISTALISTBOX_H


#include <qcombobox.h>
#include <qlistbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpainter.h>
#include <qstyle.h>
#include "kbfxconfig.h"

class VistaListBoxItem : public QListBoxItem 
{
public:
    VistaListBoxItem()
        : QListBoxItem()
    {
        setCustomHighlighting( TRUE );
	itemHeight=22;
	itemWidth= 106;
	type=0;
	_blocked = 0;
//        this->setMouseTracking(TRUE);
	ConfigInit().read();
	application_desktop = "";
ConfigInit().read();

    }

 	QPixmap drawDragPixmap();
	void setLabelText(QString * name);
	void setLabelIcon(QPixmap Normalicon);
	void setLabelIcon(QString normalIconPath);
	void setTilePixmap(QPixmap tile);
	void setTileHoverPixmap(QPixmap hovertile);
	void setHeight(int h);
	void setWidth(int w);
	void block(int b)
	{
	_blocked = b;
	}
	int isBocked()
	{
	return _blocked;
	}
	void setType(int t){ type = t;}
	void setExec(QString exec){application_exe = exec;}
	void setApplicationProperties(QString appname, QString exename,QString desktopfile);
	void setComment(QString comment) 
	{ 
	application_comment = comment;
	if (application_comment.length() > 22)
	{
	application_comment.setLength(22);
	application_comment += "...";
	}
	else if ( comment.length() == 0)
	{
	application_comment="...";
	}
	
	int len  = comment.length();
	
	for (int i = 0 ; i < len ; i++ )
	{
		
	}

	}
	QString getDesktop()
	{	
	return application_desktop;
	}
	QString setDesktop(QString name)
	{
	 application_desktop = name;
	}
	QString * getText(){return text;}
	QString  getIcon(){return application_icon;}
	QString * getName() {return text;}
	QString  getComment() {return application_comment;}
	QString  getExec() { return application_exe;}
	QPixmap tilePixmap();
	int 	getType(){return type;}

protected:
        //virtual bool eventFilter (QObject *, QEvent * e);
   //     virtual void enterEvent(QEvent * e); 
        virtual void paint( QPainter * );
//	virtual void mouseMoveEvent ( QMouseEvent * e );
        virtual int width( const QListBox* ) const { return itemWidth; }
        virtual int height( const QListBox* ) const 
	{
	if (listImageNormal.height() < 22 )
	return 22;
	else
	return listImageNormal.height(); 
	}



private:

	QPixmap iconPixmap;
	QPixmap listImageNormal;
	QPixmap listImageMouseOver;

	QString  application_icon;
	QString * application_name;
	QString  application_exe;
	QString  *application_desktop_file;
	QString  application_desktop;
	QString * application_time;
	QString  application_comment;
//TODO:to be fixed the types may change;
	QString * lastUsered;	
	QString * order;

	int itemHeight;
	int itemWidth;
	QString  * text;
	int type;
	int _blocked;
};

#endif
