#!/bin/sh

export PATH="/usr/kde/3.5/bin/${PATH/kde\/4.2/kde/3.5}"

if [ -z "$1" ] ; then
	msgmergebin=`which msgmerge`
elif [ -x "$1" ] ; then
	msgmergebin="$1"
else
	echo "The given parameter does not point to an executable file" >&2
	exit 2
fi

$msgmergebin --version |grep -q 0.10.35 || { echo "The provided msgmerge binary is most likely a non-KDE version." >&2 ; echo "Please provide the patched version as a parameter for this script." >&2 ; exit 1 ; }
echo $msgmergebin
$msgmergebin --version

PROJECT=kbibtex

cd .. ; make -f admin/Makefile.common package-messages ; cd po

catalogs=`find . -name '*.po'`
for cat in $catalogs; do
  echo $cat
  $msgmergebin -o $cat.new $cat ${PROJECT}.pot && mv $cat.new $cat
done

echo "Done"
