#include "kbiff.h"
#include "version.h"
#include <kwin.h>
#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "setupdlg.h"

static const char *description = 
  I18N_NOOP("Full featured mail notification utility.");

static KCmdLineOptions option[] =
{
   { "secure", I18N_NOOP("Run in secure mode"), 0 },
   { "profile <profile>", I18N_NOOP("Use 'profile'"), 0 },
   { 0, 0, 0 }
};

extern "C" KDE_EXPORT int kdemain(int argc, char *argv[])
{
  KAboutData aboutData( "kbiff", I18N_NOOP("KBiff"),
      kbiff_version, description, KAboutData::License_GPL,
      "(c) 1998-2008, Kurt Granroth");
  aboutData.addAuthor("Kurt Granroth",0, "granroth@kde.org");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions(option);

  KApplication app;
  KBiff kbiff(app.dcopClient());
  KBiffSetup* setup = 0;
  bool is_secure    = false;
  bool have_profile = false;
  QString profile;

  app.setMainWidget(&kbiff);

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  is_secure = args->isSet("secure");

  if (args->isSet("profile"))
  {
    profile = args->getOption("profile");
    have_profile = true;
  }

  args->clear();

  // restore this app if it is
  if (kapp->isRestored())
    kbiff.readSessionConfig();
  else
  {
    // do we have the profile option?
    if (have_profile)
    {
      setup = new KBiffSetup(profile, is_secure);
    }
    else
    {
      setup = new KBiffSetup();

      if (!setup->exec())
      {
        delete setup;
        return 0;
      }
    }
    kbiff.processSetup(setup, true);

  }

  // check if we are docked (only if restored)
  if (kbiff.isDocked())
  {
    kapp->setTopWidget(new QWidget);
    KWin::setSystemTrayWindowFor(kbiff.winId(), 0);
  }
  else
    kapp->setTopWidget(&kbiff);

  kbiff.show();

  return app.exec();
}
