#ifndef __kcd_h__
#define __kcd_h__

#include <qstring.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qlcdnumber.h>
#include <kpanelapplet.h>

extern "C" {
#include "cdaudio.h"
}

/** Some usefull constants ... */
#define STATUS_ERROR -1      //used when some error occured, e.g. no access to CD device
#define STATUS_NOT_READY 0   //used between start of the application and end of all initialization
#define STATUS_READY 1       //used when player is doing nothing
#define STATUS_EJECTED 2     //used when CD is ejected
#define STATUS_PLAYING 3     //used when CD is playing
#define STATUS_PAUSED 4      //used when CD is paused

#define TIME_NORMAL 1
#define TIME_REVERSE 2
#define TIME_TOTAL 3
#define TIME_TOTAL_REVERSE 4

/** A widget to display the current time */
class TimeDisplay : public QLCDNumber
{
         Q_OBJECT

         public:
                 TimeDisplay(QWidget* parent=0, const char *name=0) ;
         signals:
                 void changeRepr() ;
                 void settingsMenu() ;
         protected:
                 void mousePressEvent(QMouseEvent *ev) ;
};

/* The kcd applet class */
class Kcd : public KPanelApplet
{
  Q_OBJECT
 public:
  Kcd(const QString& configFile, Type t = Normal, int actions = 0,
                QWidget *parent = 0, const char *name = 0);
  ~Kcd() ;
  int widthForHeight(int height) const;
  int heightForWidth(int width) const;

  void about();
  void help();
  void preferences();
  static void changeTimeRepr() ;

 protected:
  void cddbQuery() ;
  void updateInfo() ;

 private slots:
    void init() ;
    void updateView() ;
    void updateStatus() ;
    void play() ;
    void pause() ;
    void stop() ;
    void next() ;
    void previous() ;
    void eject() ;


 private:
  int cdHandle, status, timeVisible, titleindex, cddbQueried ;
  int oldStatus, ignoreUpdate ; //necessary for synchronization ...
  //Listening to the CD-device to allow correct status information when changed by other applications
  //made this a bit harder :(

  int currentTrack ; //don't rely on disc_data.current_disc_track, because unreliable (even after frequent cd_stats)
  char *titleinfo ;
  static int timeRepr ;
  QLabel *trackInfo, *title ;
  QLCDNumber *timeInfo ;
  disc_info discInfo ;
  QTimer *viewTimer, *statusTimer ;
  struct disc_data *cdData ;
};

#endif