/***************************************************************************
                                 kcpuload.cpp
                             -------------------
    begin                : Thu Aug  5 03:26:36 GMT+1 1999

    copyright            : (C) 1999 by Markus Gustavsson
    email                : mighty@fragzone.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kcpuload.h"

KCPULoad::KCPULoad(QWidget *parent, const char *name) : KTMainWindow(name)
{
	parent = (QWidget *) 0;

	/* Alloc memory for some strings. */

	tmp = (char *) calloc(256, sizeof(char));

	/* Create the first Panel Docking diagram. */

	dock1 = new Dock(this);

	connect(dock1, SIGNAL(mouseClick(QMouseEvent *)), this, SLOT(activateMenu(QMouseEvent *)));

	/* Create the /proc reading class and check SMP. */

	proc = new Proc();

	hasSmp = proc->smpChk();

	/* QTimer for update interval. */

	t = new QTimer(this);
	connect(t, SIGNAL(timeout()), this, SLOT(step()));

	/* Create tooltip lookalike popup window. */

	popup = new PopUp();
	connect(popup, SIGNAL(clicked()), this, SLOT(hidePopUp()));
	connect(popup, SIGNAL(savePos()), this, SLOT(savePopUpPos()));

	/* Initialize Config system. */

	config = KGlobal::config();
	config->setGroup("General Options");

	smp = config->readBoolEntry("SMP", FALSE);
	split = config->readBoolEntry("Split", TRUE);
	color = config->readNumEntry("Color", 1);
	color2 = config->readNumEntry("Color2", 4);
	speed = config->readNumEntry("Speed", 1000);
	diagram = config->readNumEntry("Diagram", 2);
	grid = config->readBoolEntry("Grid", TRUE);
	active = config->readBoolEntry("Active", TRUE);
	text = config->readBoolEntry("Text", TRUE);
	soft = config->readBoolEntry("Soft", FALSE);
	popupX = config->readNumEntry("PopupX", 0);
	popupY = config->readNumEntry("PopupY", 0);
	popupOn = config->readBoolEntry("PopupActive", FALSE);

	/* Load Icons for menues. */

	KStandardDirs *stddirs = KGlobal::dirs();

		/* Color Nyances Pixmaps. */

	PixBlue.load(stddirs->findResource("data", "kcpuload/icons/blue.xpm"));
	PixBlueOn.load(stddirs->findResource("data", "kcpuload/icons/blueon.xpm"));
	PixGreen.load(stddirs->findResource("data", "kcpuload/icons/green.xpm"));
	PixGreenOn.load(stddirs->findResource("data", "kcpuload/icons/greenon.xpm"));
	PixOrange.load(stddirs->findResource("data", "kcpuload/icons/orange.xpm"));
	PixOrangeOn.load(stddirs->findResource("data", "kcpuload/icons/orangeon.xpm"));
	PixPurple.load(stddirs->findResource("data", "kcpuload/icons/purple.xpm"));
	PixPurpleOn.load(stddirs->findResource("data", "kcpuload/icons/purpleon.xpm"));
	PixRed.load(stddirs->findResource("data", "kcpuload/icons/red.xpm"));
	PixRedOn.load(stddirs->findResource("data", "kcpuload/icons/redon.xpm"));
	PixTurquoise.load(stddirs->findResource("data", "kcpuload/icons/turquoise.xpm"));
	PixTurquoiseOn.load(stddirs->findResource("data", "kcpuload/icons/turquoiseon.xpm"));
	PixYellow.load(stddirs->findResource("data", "kcpuload/icons/yellow.xpm"));
	PixYellowOn.load(stddirs->findResource("data", "kcpuload/icons/yellowon.xpm"));

		/* Diagram Styles Pixmaps. */

	PixLines.load(stddirs->findResource("data", "kcpuload/icons/lines.xpm"));
	PixLinesOn.load(stddirs->findResource("data", "kcpuload/icons/lineson.xpm"));
	PixBars.load(stddirs->findResource("data", "kcpuload/icons/bars.xpm"));
	PixBarsOn.load(stddirs->findResource("data", "kcpuload/icons/barson.xpm"));
	PixShaded.load(stddirs->findResource("data", "kcpuload/icons/shaded.xpm"));
	PixShadedOn.load(stddirs->findResource("data", "kcpuload/icons/shadedon.xpm"));

		/* Brother Pixmaps. */

	PixLabels.load(stddirs->findResource("data", "kcpuload/icons/labels.xpm"));
	PixLabelsOn.load(stddirs->findResource("data", "kcpuload/icons/labelson.xpm"));
	PixGrid.load(stddirs->findResource("data", "kcpuload/icons/grid.xpm"));
	PixGridOn.load(stddirs->findResource("data", "kcpuload/icons/gridon.xpm"));
	PixSMP.load(stddirs->findResource("data", "kcpuload/icons/smp.xpm"));
	PixSMPOn.load(stddirs->findResource("data", "kcpuload/icons/smpon.xpm"));
	PixSplit.load(stddirs->findResource("data", "kcpuload/icons/split.xpm"));
	PixSplitOn.load(stddirs->findResource("data", "kcpuload/icons/spliton.xpm"));
	PixAct.load(stddirs->findResource("data", "kcpuload/icons/active.xpm"));
	PixActOn.load(stddirs->findResource("data", "kcpuload/icons/activeon.xpm"));
	PixSoft.load(stddirs->findResource("data", "kcpuload/icons/soft.xpm"));
	PixSoftOn.load(stddirs->findResource("data", "kcpuload/icons/softon.xpm"));
	PixArrow.load(stddirs->findResource("data", "kcpuload/icons/arrow.xpm"));
	PixTrans.load(stddirs->findResource("data", "kcpuload/icons/trans.xpm"));

		/* Other mixed settings Pixmaps. */

	PixClear.load(stddirs->findResource("data", "kcpuload/icons/clear.xpm"));
	PixQuit.load(stddirs->findResource("data", "kcpuload/icons/exit.xpm"));
	PixAbout.load(stddirs->findResource("data", "kcpuload/icons/about.xpm"));
	PixHelp.load(stddirs->findResource("data", "kcpuload/icons/help.xpm"));
	PixSpeedArrow.load(stddirs->findResource("data", "kcpuload/icons/speedarrow.xpm"));
	PixStyle.load(stddirs->findResource("data", "kcpuload/icons/style.xpm"));

	PixColor.load(stddirs->findResource("data", "kcpuload/icons/color.xpm"));
	PixColor1.load(stddirs->findResource("data", "kcpuload/icons/color1.xpm"));
	PixColor2.load(stddirs->findResource("data", "kcpuload/icons/color2.xpm"));

	/* Menu System Initializing. */

	Color = new QPopupMenu();

	colorIdBlue = Color->insertItem(PixBlue, "Blue ", this, SLOT(setColBlue()));
	colorIdGreen = Color->insertItem(PixGreen, "Green ", this, SLOT(setColGreen()));
	colorIdOrange = Color->insertItem(PixOrange, "Orange ", this, SLOT(setColOrange()));
	colorIdPurple = Color->insertItem(PixPurple, "Purple ", this, SLOT(setColPurple()));
	colorIdRed = Color->insertItem(PixRed, "Red ", this, SLOT(setColRed()));
	colorIdTurquoise = Color->insertItem(PixTurquoise, "Turquo ", this, SLOT(setColTurquoise()));
	colorIdYellow = Color->insertItem(PixYellow, "Yellow ", this, SLOT(setColYellow()));

	if(hasSmp) {

		Color2 = new QPopupMenu();

		colorIdBlue2 = Color2->insertItem(PixBlue, "Blue ", this, SLOT(setColBlue2()));
		colorIdGreen2 = Color2->insertItem(PixGreen, "Green ", this, SLOT(setColGreen2()));
		colorIdOrange2 = Color2->insertItem(PixOrange, "Orange ", this, SLOT(setColOrange2()));
		colorIdPurple2 = Color2->insertItem(PixPurple, "Purple ", this, SLOT(setColPurple2()));
		colorIdRed2 = Color2->insertItem(PixRed, "Red ", this, SLOT(setColRed2()));
		colorIdTurquoise2 = Color2->insertItem(PixTurquoise, "Turquo ", this, SLOT(setColTurquoise2()));
		colorIdYellow2 = Color2->insertItem(PixYellow, "Yellow ", this, SLOT(setColYellow2()));

	}

	Speed = new QPopupMenu();

	speedId100 = Speed->insertItem(PixTrans, "100ms ", this, SLOT(setSpeed100()));
	speedId150 = Speed->insertItem(PixTrans, "150ms ", this, SLOT(setSpeed150()));
	speedId200 = Speed->insertItem(PixTrans, "200ms ", this, SLOT(setSpeed200()));
	speedId250 = Speed->insertItem(PixTrans, "250ms ", this, SLOT(setSpeed250()));
	speedId300 = Speed->insertItem(PixTrans, "300ms ", this, SLOT(setSpeed300()));
	speedId400 = Speed->insertItem(PixTrans, "400ms ", this, SLOT(setSpeed400()));
	speedId600 = Speed->insertItem(PixTrans, "600ms ", this, SLOT(setSpeed600()));
	speedId800 = Speed->insertItem(PixTrans, "800ms ", this, SLOT(setSpeed800()));
	speedId1000 = Speed->insertItem(PixTrans, "1000ms ", this, SLOT(setSpeed1000()));
	speedId1200 = Speed->insertItem(PixTrans, "1200ms ", this, SLOT(setSpeed1200()));
	speedId1500 = Speed->insertItem(PixTrans, "1500ms ", this, SLOT(setSpeed1500()));
	speedId2000 = Speed->insertItem(PixTrans, "2000ms ", this, SLOT(setSpeed2000()));
	speedId2500 = Speed->insertItem(PixTrans, "2500ms ", this, SLOT(setSpeed2500()));
	speedId3000 = Speed->insertItem(PixTrans, "3000ms ", this, SLOT(setSpeed3000()));
	speedId4000 = Speed->insertItem(PixTrans, "4000ms ", this, SLOT(setSpeed4000()));
	speedId5000 = Speed->insertItem(PixTrans, "5000ms ", this, SLOT(setSpeed5000()));

	Diagram = new QPopupMenu();

	diagramIdLines = Diagram->insertItem(PixLines, "Lines ", this, SLOT(setDiagramLines()));
	diagramIdBars = Diagram->insertItem(PixBars, "Bars ", this, SLOT(setDiagramBars()));
	diagramIdShaded = Diagram->insertItem(PixShaded, "Shade ", this, SLOT(setDiagramShaded()));

	Menu = new QPopupMenu();

	HelpMenu = new KHelpMenu(qApp->desktop(), kapp->aboutData());

	if(hasSmp) menuIdSMP = Menu->insertItem((smp) ? PixSMPOn : PixSMP, "SMP", this, SLOT(setSMP()));
	menuIdSplit = Menu->insertItem((split) ? PixSplitOn : PixSplit, "Split", this, SLOT(setSplit()));
	menuIdSoft = Menu->insertItem((soft) ? PixSoftOn : PixSoft, "Soft", this, SLOT(setSoft()));
	menuIdText = Menu->insertItem((text) ? PixLabelsOn : PixLabels, "Labels", this, SLOT(setText()));
	menuIdGrid = Menu->insertItem((grid) ? PixGridOn : PixGrid, "Grid", this, SLOT(setGrid()));
	menuIdActive = Menu->insertItem((active) ? PixActOn : PixAct, "Active", this, SLOT(setActive()));
	Menu->insertItem(PixClear, "Clear", this, SLOT(sendSetClr()));
	Menu->insertSeparator();
	menuIdCol1 = Menu->insertItem((hasSmp && smp) ? PixColor1 : PixColor, (hasSmp && smp) ? "Color 0" : "Color", Color);
	if(hasSmp && smp) menuIdCol2 = Menu->insertItem(PixColor2, "Color 1", Color2);
	Menu->insertItem(PixSpeedArrow, "Speed", Speed);
	Menu->insertItem(PixStyle, "Style", Diagram);
	Menu->insertSeparator();
	Menu->insertItem(PixHelp, "Help", this, SLOT(showHelp()));
	Menu->insertItem(PixAbout, "About", HelpMenu, SLOT(aboutApplication()));
	Menu->insertItem(PixQuit, "Quit", kapp, SLOT(quit()));

	/* initialize configuration settings. */

//	if(!hasSmp) Menu->setItemEnabled(menuIdSMP, false);

	if(hasSmp && smp) {
		dock2 = new Dock(this);
		connect(dock2, SIGNAL(mouseClick(QMouseEvent *)), this, SLOT(activateMenu(QMouseEvent *)));
		dock1->setCPU(1);
		dock2->setCPU(2);
		popup->setSize(TRUE, split);
	} else {
		dock1->setCPU(0);
		popup->setSize(FALSE, split);
	}

	setCol(color);
	if(hasSmp && smp) setCol2(color2);

	setSpeed(speed);
	setDiagram(diagram);

	proc->setSplit(split);
	dock1->setSplit(split);
	if(hasSmp && smp) dock2->setSplit(split);

	dock1->setGrid(grid);
	if(hasSmp && smp) dock2->setGrid(grid);

	dock1->setOn(active);
	if(hasSmp && smp) dock2->setOn(active);

	dock1->setText(text);
	if(hasSmp && smp) dock2->setText(text);

	dock1->setSoft(soft);
	if(hasSmp && smp) dock2->setSoft(soft);

	if(popupOn) showPopUp(QPoint(0, 0));

}

KCPULoad::~KCPULoad()
{
	free(tmp);
}

void KCPULoad::activateMenu(QMouseEvent *Event)
{
	if(Event->button() == RightButton) Menu->popup(Event->globalPos());
	if(Event->button() == LeftButton) {
		if(!popupOn) showPopUp(Event->globalPos());
		else hidePopUp();
	}
}

void KCPULoad::setCol(int set)
{
	color = set;

	config->writeEntry("Color", color);
	config->sync();

	dock1->setCol(color);

	Color->changeItem(PixBlue, "Blue ", colorIdBlue);
	Color->changeItem(PixGreen, "Green ", colorIdGreen);
	Color->changeItem(PixOrange, "Orange ", colorIdOrange);
	Color->changeItem(PixPurple, "Purple ", colorIdPurple);
	Color->changeItem(PixRed, "Red ", colorIdRed);
	Color->changeItem(PixTurquoise, "Turquo ", colorIdTurquoise);
	Color->changeItem(PixYellow, "Yellow ", colorIdYellow);

	switch(color) {
		case 0: Color->changeItem(PixBlueOn, "Blue ", colorIdBlue);
		break;
		case 1: Color->changeItem(PixGreenOn, "Green ", colorIdGreen);
		break;
		case 2: Color->changeItem(PixOrangeOn, "Orange ", colorIdOrange);
		break;
		case 3: Color->changeItem(PixPurpleOn, "Purple ", colorIdPurple);
		break;
		case 4: Color->changeItem(PixRedOn, "Red ", colorIdRed);
		break;
		case 5: Color->changeItem(PixTurquoiseOn, "Turquo ", colorIdTurquoise);
		break;
		case 6: Color->changeItem(PixYellowOn, "Yellow ", colorIdYellow);
		break;
	}
}

void KCPULoad::setColBlue(void) { setCol(0); }
void KCPULoad::setColGreen(void) { setCol(1); }
void KCPULoad::setColOrange(void) { setCol(2); }
void KCPULoad::setColPurple(void) { setCol(3); }
void KCPULoad::setColRed(void) { setCol(4); }
void KCPULoad::setColTurquoise(void) { setCol(5); }
void KCPULoad::setColYellow(void) { setCol(6); }

void KCPULoad::setCol2(int set)
{
	color2 = set;

	config->writeEntry("Color2", color2);
	config->sync();

	dock2->setCol(color2);

	Color2->changeItem(PixBlue, "Blue ", colorIdBlue2);
	Color2->changeItem(PixGreen, "Green ", colorIdGreen2);
	Color2->changeItem(PixOrange, "Orange ", colorIdOrange2);
	Color2->changeItem(PixPurple, "Purple ", colorIdPurple2);
	Color2->changeItem(PixRed, "Red ", colorIdRed2);
	Color2->changeItem(PixTurquoise, "Turquo ", colorIdTurquoise2);
	Color2->changeItem(PixYellow, "Yellow ", colorIdYellow2);

	switch(color2) {
		case 0: Color2->changeItem(PixBlueOn, "Blue ", colorIdBlue2);
		break;
		case 1: Color2->changeItem(PixGreenOn, "Green ", colorIdGreen2);
		break;
		case 2: Color2->changeItem(PixOrangeOn, "Orange ", colorIdOrange2);
		break;
		case 3: Color2->changeItem(PixPurpleOn, "Purple ", colorIdPurple2);
		break;
		case 4: Color2->changeItem(PixRedOn, "Red ", colorIdRed2);
		break;
		case 5: Color2->changeItem(PixTurquoiseOn, "Turquo ", colorIdTurquoise2);
		break;
		case 6: Color2->changeItem(PixYellowOn, "Yellow ", colorIdYellow2);
		break;
	}
}

void KCPULoad::setColBlue2(void) { setCol2(0); }
void KCPULoad::setColGreen2(void) { setCol2(1); }
void KCPULoad::setColOrange2(void) { setCol2(2); }
void KCPULoad::setColPurple2(void) { setCol2(3); }
void KCPULoad::setColRed2(void) { setCol2(4); }
void KCPULoad::setColTurquoise2(void) { setCol2(5); }
void KCPULoad::setColYellow2(void) { setCol2(6); }

void KCPULoad::setSpeed(int set)
{
	speed = set;

	config->writeEntry("Speed", speed);
	config->sync();

	if(active) t->changeInterval(speed);

	Speed->changeItem(PixTrans, "100ms ", speedId100);
	Speed->changeItem(PixTrans, "150ms ", speedId150);
	Speed->changeItem(PixTrans, "200ms ", speedId200);
	Speed->changeItem(PixTrans, "250ms ", speedId250);
	Speed->changeItem(PixTrans, "300ms ", speedId300);
	Speed->changeItem(PixTrans, "400ms ", speedId400);
	Speed->changeItem(PixTrans, "600ms ", speedId600);
	Speed->changeItem(PixTrans, "800ms ", speedId800);
	Speed->changeItem(PixTrans, "1000ms ", speedId1000);
	Speed->changeItem(PixTrans, "1200ms ", speedId1200);
	Speed->changeItem(PixTrans, "1500ms ", speedId1500);
	Speed->changeItem(PixTrans, "2000ms ", speedId2000);
	Speed->changeItem(PixTrans, "2500ms ", speedId2500);
	Speed->changeItem(PixTrans, "3000ms ", speedId3000);
	Speed->changeItem(PixTrans, "4000ms ", speedId4000);
	Speed->changeItem(PixTrans, "5000ms ", speedId5000);

	switch(speed) {
	case 100: Speed->changeItem(PixArrow, "100ms ", speedId100);
	break;
	case 150: Speed->changeItem(PixArrow, "150ms ", speedId150);
	break;
	case 200: Speed->changeItem(PixArrow, "200ms ", speedId200);
	break;
	case 250: Speed->changeItem(PixArrow, "250ms ", speedId250);
	break;
	case 300: Speed->changeItem(PixArrow, "300ms ", speedId300);
	break;
	case 400: Speed->changeItem(PixArrow, "400ms ", speedId400);
	break;
	case 600: Speed->changeItem(PixArrow, "600ms ", speedId600);
	break;
	case 800: Speed->changeItem(PixArrow, "800ms ", speedId800);
	break;
	case 1000: Speed->changeItem(PixArrow, "1000ms ", speedId1000);
	break;
	case 1200: Speed->changeItem(PixArrow, "1200ms ", speedId1200);
	break;
	case 1500: Speed->changeItem(PixArrow, "1500ms ", speedId1500);
	break;
	case 2000: Speed->changeItem(PixArrow, "2000ms ", speedId2000);
	break;
	case 2500: Speed->changeItem(PixArrow, "2500ms ", speedId2500);
	break;
	case 3000: Speed->changeItem(PixArrow, "3000ms ", speedId3000);
	break;
	case 4000: Speed->changeItem(PixArrow, "4000ms ", speedId4000);
	break;
	case 5000: Speed->changeItem(PixArrow, "5000ms ", speedId5000);
	break;
	}
}

void KCPULoad::setSpeed100(void) { setSpeed(100); }
void KCPULoad::setSpeed150(void) { setSpeed(150); }
void KCPULoad::setSpeed200(void) { setSpeed(200); }
void KCPULoad::setSpeed250(void) { setSpeed(250); }
void KCPULoad::setSpeed300(void) { setSpeed(300); }
void KCPULoad::setSpeed400(void) { setSpeed(400); }
void KCPULoad::setSpeed600(void) { setSpeed(600); }
void KCPULoad::setSpeed800(void) { setSpeed(800); }
void KCPULoad::setSpeed1000(void) { setSpeed(1000); }
void KCPULoad::setSpeed1200(void) { setSpeed(1200); }
void KCPULoad::setSpeed1500(void) { setSpeed(1500); }
void KCPULoad::setSpeed2000(void) { setSpeed(2000); }
void KCPULoad::setSpeed2500(void) { setSpeed(2500); }
void KCPULoad::setSpeed3000(void) { setSpeed(3000); }
void KCPULoad::setSpeed4000(void) { setSpeed(4000); }
void KCPULoad::setSpeed5000(void) { setSpeed(5000); }

void KCPULoad::setDiagram(int set)
{
	diagram = set;

	config->writeEntry("Diagram", diagram);
	config->sync();

	dock1->setFill(diagram);
	if(hasSmp && smp) dock2->setFill(diagram);

	Diagram->changeItem(PixLines, "Lines ", diagramIdLines);
	Diagram->changeItem(PixBars, "Bars ", diagramIdBars);
	Diagram->changeItem(PixShaded, "Shade ", diagramIdShaded);

	switch(diagram) {
		case 0: Diagram->changeItem(PixLinesOn, "Lines ", diagramIdLines);
		break;
		case 1: Diagram->changeItem(PixBarsOn, "Bars ", diagramIdBars);
		break;
		case 2: Diagram->changeItem(PixShadedOn, "Shade ", diagramIdShaded);
		break;
	}
}

void KCPULoad::setDiagramLines(void) { setDiagram(0); }
void KCPULoad::setDiagramBars(void) { setDiagram(1); }
void KCPULoad::setDiagramShaded(void) { setDiagram(2); }

void KCPULoad::setGrid(void)
{
	grid = (grid) ? FALSE : TRUE;

	config->writeEntry("Grid", grid);
	config->sync();

	dock1->setGrid(grid);
	if(hasSmp && smp) dock2->setGrid(grid);

	Menu->changeItem((grid) ? PixGridOn : PixGrid, "Grid", menuIdGrid);
}

void KCPULoad::setActive(void)
{
	active = (active) ? FALSE : TRUE;

	config->writeEntry("Active", active);
	config->sync();

	if(active) t->start(speed, FALSE);
	else t->stop();

	dock1->setOn(active);
	if(hasSmp && smp) dock2->setOn(active);

	Menu->changeItem((active) ? PixActOn : PixAct, "Active", menuIdActive);
}

void KCPULoad::setText(void)
{
	text = (text) ? FALSE : TRUE;

	config->writeEntry("Text", text);
	config->sync();

	dock1->setText(text);
	if(hasSmp && smp) dock2->setText(text);

	Menu->changeItem((text) ? PixLabelsOn : PixLabels, "Labels", menuIdText);
}

void KCPULoad::setSoft(void)
{
	soft = (soft) ? FALSE : TRUE;

	config->writeEntry("Soft", soft);
	config->sync();

	dock1->setSoft(soft);
	if(hasSmp && smp) dock2->setSoft(soft);

	Menu->changeItem((soft) ? PixSoftOn : PixSoft, "Soft", menuIdSoft);
}

void KCPULoad::sendSetClr(void)
{
	dock1->setClr();
	if(hasSmp && smp) dock2->setClr();
}

void KCPULoad::setSMP(void)
{
	smp = (smp) ? FALSE : TRUE;

	config->writeEntry("SMP", smp);
	config->sync();

	if(hasSmp && smp) {

		dock2 = new Dock(this);
		connect(dock2, SIGNAL(mouseClick(QMouseEvent *)), this, SLOT(activateMenu(QMouseEvent *)));

		dock1->setCPU(1);
		dock2->setCPU(2);

		popup->setSize(TRUE, split);
		popup->setText("??");

		setCol(color);
		setCol2(color2);
		setSpeed(speed);
		setDiagram(diagram);

		dock2->setGrid(grid);
		dock2->setOn(active);
		dock2->setText(text);

		Menu->changeItem(PixColor1, "Color 0", menuIdCol1);
		menuIdCol2 = Menu->insertItem(PixColor2, "Color 1", Color2, -1, 9);

	} else {

		dock1->setCPU(0);

		popup->setSize(FALSE, split);
		popup->setText("??");

		delete dock2;

		dock2 = NULL;

		Menu->changeItem(PixColor, "Color", menuIdCol1);
		Menu->removeItem(menuIdCol2);

	}

	Menu->changeItem((smp) ? PixSMPOn : PixSMP, "SMP", menuIdSMP);

}

void KCPULoad::setSplit(void)
{
	split = (split) ? FALSE : TRUE;

	config->writeEntry("Split", split);
	config->sync();

	proc->setSplit(split);
	popup->setText("??");
	dock1->setSplit(split);
	if(hasSmp && smp) {
		dock2->setSplit(split);
		popup->setSize(TRUE, split);
	} else popup->setSize(FALSE, split);

	Menu->changeItem((split) ? PixSplitOn : PixSplit, "Split", menuIdSplit);
}

void KCPULoad::showPopUp(QPoint Point)
{
	popupOn = TRUE;

	config->writeEntry("PopupActive", popupOn);
	config->sync();

	if(popupX == 0 && popupY == 0) {
		popupX = Point.x() - 220;
		popupY = Point.y() - 100;
	}

	popup->show();
	popup->move(popupX, popupY);
}

void KCPULoad::hidePopUp(void)
{
	popupOn = FALSE;

	savePopUpPos();

	popup->hide();
}

void KCPULoad::savePopUpPos(void)
{
	popupX = popup->x();
	popupY = popup->y();

	config->writeEntry("PopupActive", popupOn);
	config->writeEntry("PopupX", popupX);
	config->writeEntry("PopupY", popupY);
	config->sync();
}

void KCPULoad::step(void)
{
	cVal = proc->readLoad();

	if(hasSmp && smp) {
		dock1->step(cVal[2], cVal[3]);
		dock2->step(cVal[4], cVal[5]);
		if(popupOn) {
			if(split) {
				sprintf(tmp, "Current CPU User: %d%c, C0: %d%c, C1: %d%c.\nCurrent CPU System: %d%c, C0: %d%c, C1: %d%c.",
									cVal[0], 37, cVal[2], 37, cVal[4], 37, cVal[1], 37, cVal[3], 37, cVal[5], 37);
				popup->setText(tmp);
			} else {
				sprintf(tmp, "Current CPU usage: %d%c, C0: %d%c, C1: %d%c.", cVal[0], 37, cVal[2], 37, cVal[4], 37);
				popup->setText(tmp);
			}
		}
	} else {
		dock1->step(cVal[0], cVal[1]);
		if(popupOn) {
			if(split) {
				sprintf(tmp, "Current CPU User: %d%c.\nCurrent CPU System: %d%c.",
									cVal[0], 37, cVal[1], 37);
				popup->setText(tmp);
			} else {
				sprintf(tmp, "Current CPU usage: %d%c.", cVal[0], 37);
				popup->setText(tmp);
			}
		}
	}

}

void KCPULoad::showHelp(void)
{
	KStandardDirs *stddirs = KGlobal::dirs();
	kapp->invokeBrowser(QString("file:") + stddirs->findResource("data", "kcpuload/docs/index.html"));
}









