/***************************************************************************
                                 kcpuload.h
                             -------------------
    begin                : Thu Aug  5 03:26:36 GMT+1 1999

    copyright            : (C) 1999 by Markus Gustavsson
    email                : mighty@fragzone.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KCPULOAD_H
#define KCPULOAD_H

#include "../version.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <qevent.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qstring.h>

#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>
#include <ktmainwindow.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <klocale.h>
#include <khelpmenu.h>

#include "proc.h"
#include "dock.h"
#include "popup.h"

class KCPULoad : public KTMainWindow {
	Q_OBJECT
public:

	KCPULoad(QWidget *parent = 0, const char *name = 0);
	~KCPULoad();

private:

	Proc *proc;

	Dock *dock1, *dock2;

	KConfig *config;

	QTimer *t;

	PopUp *popup;

	KHelpMenu *HelpMenu;

	QPopupMenu *Menu, *Color, *Color2, *Speed, *Diagram;

	QPixmap PixBlue, PixBlueOn;
	QPixmap PixGreen, PixGreenOn;
	QPixmap PixOrange, PixOrangeOn;
	QPixmap PixPurple, PixPurpleOn;
	QPixmap PixRed, PixRedOn;
	QPixmap PixTurquoise, PixTurquoiseOn;
	QPixmap PixYellow, PixYellowOn;

	QPixmap PixLines, PixLinesOn;
	QPixmap PixBars, PixBarsOn;
	QPixmap PixShaded, PixShadedOn;

	QPixmap PixLabels, PixLabelsOn;
	QPixmap PixGrid, PixGridOn;
	QPixmap PixAct, PixActOn;
	QPixmap PixSoft, PixSoftOn;
	QPixmap PixSMP, PixSMPOn;
	QPixmap PixSplit, PixSplitOn;
	QPixmap PixArrow, PixTrans;
	QPixmap PixColor1, PixColor2;

	QPixmap PixClear, PixQuit, PixAbout, PixHelp, PixSpeedArrow, PixStyle, PixColor;

	int color, colorIdBlue, colorIdGreen, colorIdOrange, colorIdPurple, colorIdRed, colorIdTurquoise, colorIdYellow;
	int color2, colorIdBlue2, colorIdGreen2, colorIdOrange2, colorIdPurple2, colorIdRed2, colorIdTurquoise2, colorIdYellow2;
	int speed, speedId100, speedId150, speedId200, speedId250, speedId300, speedId400, speedId600, speedId800;
	int speedId1000, speedId1200, speedId1500, speedId2000, speedId2500, speedId3000, speedId4000, speedId5000;
	int diagram, diagramIdLines, diagramIdBars, diagramIdShaded;

	int menuIdGrid, menuIdActive, menuIdSMP, menuIdSplit, menuIdText, menuIdSoft, menuIdCol2, menuIdCol1, *cVal;

	int popupX, popupY;

	bool grid, active, hasSmp, smp, split, text, soft, popupOn;

	char *aboutString, *tmp;

private slots:

	void activateMenu(QMouseEvent *);

	void setCol(int);
	void setColBlue(void);
	void setColGreen(void);
	void setColOrange(void);
	void setColPurple(void);
	void setColRed(void);
	void setColTurquoise(void);
	void setColYellow(void);

	void setCol2(int);
	void setColBlue2(void);
	void setColGreen2(void);
	void setColOrange2(void);
	void setColPurple2(void);
	void setColRed2(void);
	void setColTurquoise2(void);
	void setColYellow2(void);

	void setSpeed(int);
	void setSpeed100(void);
	void setSpeed150(void);
	void setSpeed200(void);
	void setSpeed250(void);
	void setSpeed300(void);
	void setSpeed400(void);
	void setSpeed600(void);
	void setSpeed800(void);
	void setSpeed1000(void);
	void setSpeed1200(void);
	void setSpeed1500(void);
	void setSpeed2000(void);
	void setSpeed2500(void);
	void setSpeed3000(void);
	void setSpeed4000(void);
	void setSpeed5000(void);

	void setDiagram(int);
	void setDiagramLines(void);
	void setDiagramBars(void);
	void setDiagramShaded(void);

	void setGrid(void);
	void setActive(void);
	void setText(void);
	void setSoft(void);
	void sendSetClr(void);
	void setSMP(void);
	void setSplit(void);

	void showPopUp(QPoint);
	void hidePopUp(void);
	void savePopUpPos(void);

	void step(void);

	void showHelp(void);
};

#endif










































