#ifndef _GImage_H
#define _GImage_H

/* Abstract class for describing a generalized RGB image.  Images have
 * width, height, aspect ratio, comments, and RGB pixels stored as int
 * with values typically in the range [-16384,16383], but may be outside
 * this range.
 * 
 * Written by:  Chris Studholme
 * Last Update: 8-January-2000
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

class GImage {
  /*
   * This class is abstract.  Only instanciate a derived class.
   */

 public:
  virtual ~GImage() {
  }

  virtual const char* getComments()=0;
  virtual int getWidth()=0;
  virtual int getHeight()=0;
  virtual int getPreferredWidth()=0;
  virtual int getPreferredHeight()=0;

  /* width/height of individual pixel */
  virtual double getAspectRatio()=0;

  /* must have x1<x2, y1<y2,
   * pixel values are typically in [-16384,16383], but may be
   * out of this range
   */
  virtual void getPixel(short& red, short& green, short& blue,
			float x1, float y1, float x2, float y2)=0;

  /* must have y1<y2
   */
  virtual void getScanLineHorz(short* red, short* green, short* blue,
			       float x1, float y1, 
			       float x2, float y2, int npixels);
  /* must have x1<x2
   */
  virtual void getScanLineVert(short* red, short* green, short* blue,
			       float x1, float y1, 
			       float x2, float y2, int npixels);
};

#endif
