/*****************************************************************/
/* 	$Id: rpmMessages.c,v 1.18 2001/02/21 00:33:58 waba Exp $ */
#include "../config.h"

#ifdef HAVE_RPM
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
/* stupid RPM headers! */
typedef __off64_t off64_t;
#include <rpm/rpmlib.h>
#include "rpmMessages.h"

static int minLevel = RPMMESS_NORMAL;

#  if RPM_V1 == 3 && RPM_V2 == 0 && RPM_V3 <= 2
 char *specedit = NULL;    
#  endif

void kpackage_rpmIncreaseVerbosity(void) 
{
  minLevel--;
}

void kpackage_rpmSetVerbosity(int level) 
{
  minLevel = level;
}

int kpackage_rpmGetVerbosity(void)
{
  return minLevel;
}

int kpackage_rpmIsDebug(void)
{
  return (minLevel <= RPMMESS_DEBUG);
}

int kpackage_rpmIsVerbose(void)
{
  return (minLevel <= RPMMESS_VERBOSE);
}

/* Awful hack... */
#if RPM_V1 != 3 || RPM_V2 != 0 || RPM_V3 != 6
#  if RPM_V1 >= 4 || (RPM_V1 >= 3 && RPM_V2 == 0 && RPM_V3 >= 1)
void rpmMessage(int level,  const char * format, ...) 
#  else
void rpmMessage(int level, char * format, ...) 
#  endif
{
  char buffer[1200];
  char f[400];
  char *p;

  va_list args;

  strncpy(f,format,400);

  va_start(args, format);

  if (level >= minLevel) 
    {
      switch (level) 
	{
	case RPMMESS_VERBOSE:
	case RPMMESS_NORMAL:
	  vsprintf(buffer, f, args);
	  break;
	  
	case RPMMESS_DEBUG:
	  vsprintf(buffer, f, args);
	  break;
	  
	case RPMMESS_WARNING:
	  vsprintf(buffer, f, args);
	  /*	  printf("%s\n",buffer);*/
	  break;
	  
	case RPMMESS_ERROR:
	  vsprintf(buffer, f, args);
	  rpmMess(buffer);
 	  printf("%s\n",buffer);
	  break;
	  
	case RPMMESS_FATALERROR:
	  vsprintf(buffer, f, args);
	  rpmMess(buffer);
	  break;
	}

      /*   remove newlines */
      p = f;
      while(*p) {
        if(*p == '\n')
	  *p = ' ';
	p++;
      }

      rpmBuff(buffer);
    }
}
#endif

#  if RPM_V1 >= 3 && RPM_V2 == 0 && RPM_V3 < 2

void printDepFlags(FILE * f, const char * version, int flags) { 
  printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n");
}
#  endif

#  if RPM_V1 == 3 && RPM_V2 == 0 && RPM_V3 <= 2

int dummy()
{
  freeSpec();
}

#ifndef HAVE_UFDOPEN

int ufdClose(FD_t fd)
{
    return fdClose(fd);
}


FD_t ufdOpen(const char *url, int flags, mode_t mode)
{
  FD_t fd = NULL;
  fd = fdOpen(url, flags, mode);
    if (fd == NULL || fdFileno(fd) < 0) {
	ufdClose(fd);
	return NULL;
    }
    return fd;
}

#  endif
# endif
#endif
