/* kplview.cpp
**
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include "../config.h"
#include <qpixmap.h>

// kpackage.headers
#include "kpackage.h"
#include "pkgInterface.h"
#include "packageInfo.h"
#include "managementWidget.h"
#include "kplview.h"

#define MPOS  1

KPQListView::KPQListView( QWidget *parent ) :
KListView (parent)
{
  markPkg = 0;
  setShowSortIndicator(true);
}

void KPQListView::clear()
{
  markPkg = 0;
  KListView::clear();
}

KPLVItem *KPQListView::firstChild()
{
  return  (KPLVItem *)KListView::firstChild();
}

KPLVItem *KPQListView::currentItem()
{
  return  (KPLVItem *)KListView::currentItem();
}

void KPQListView::contentsMousePressEvent ( QMouseEvent * e )
{
  bool markUpdate = false;

  if (e->button() == LeftButton) {
    if (inMark(e->x())) {
      QPoint vp = contentsToViewport(e->pos());
      KPLVItem *i = ( KPLVItem *)itemAt( vp );
      if (i && i->childCount() == 0) {   
	if (e->state() == ShiftButton) {
	  if (i->childCount() == 0) {
	    i->setMark(true);
	    markUpdate = true;
	  }
	  KPLVItem *item = i;
	  while ((item = (KPLVItem *)item->itemAbove()) && !item->marked) {;}
	  if (item) {
	    item = i;
	    while ((item = (KPLVItem *)item->itemAbove()) && !item->marked) {
	      if (item->childCount() == 0) {
		item->setMark(true);
		markUpdate = true;
	      }
	    }
	  } else {
	    item = i;
	    while ((item = (KPLVItem *)item->itemBelow()) && !item->marked) {;}
	    if (item) {
	      item = i;
	      while ((item = (KPLVItem *)item->itemBelow()) && !item->marked) {
		if (item->childCount() == 0) {
		  item->setMark(true);
		  markUpdate = true;
		}
	      }
	    }
	  }
	} else {
	  i->toggleMark();
	  markUpdate = true;
	}
	setCurrentItem(i);
      } else 
	KListView::contentsMousePressEvent (e);
    } else 
      KListView::contentsMousePressEvent (e);
  }
  
  if (markUpdate)
     emit updateMarked();

}
 
bool KPQListView::inMark(int x) {
  int st = 0;
  int i;

  for (i = 0; i < MPOS; i++)
    st += columnWidth(i);

   return (x >= st && x <= st + columnWidth(MPOS));
}


//////////////////////////////////////////////////////////////////////////////
KPLVItem::KPLVItem( QListViewItem *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  QString label1, QString label2 ,
                  QString label3 , QString label4 ,
                  QString label5 , QString label6 ,
                  QString label7 , QString label8 
 
) :  QListViewItem(parent, label1, label2, label3, label4, label5,
                label6, label7, label8)
{
  info = pinfo;
  marked = false;
  setPixmap(0, thePixmap);
  if (!label2.isNull())
    setPixmap(1,info->interface->markUnInst);
}
 
KPLVItem::KPLVItem( KListView *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  QString label1, QString label2 ,
                  QString label3 , QString label4 ,
                  QString label5 , QString label6 ,
                  QString label7 , QString label8 
) :  QListViewItem(parent, label1, label2, label3, label4, label5,
                label6, label7, label8)
{
  info = pinfo;
  marked = false;
  setPixmap(0, thePixmap);
  if (!label2.isNull())
    setPixmap(1,info->interface->markUnInst);
}

KPLVItem *KPLVItem::firstChild()
{
  return  (KPLVItem *)QListViewItem::firstChild();
}

KPLVItem *KPLVItem::nextSibling()
{
  return  (KPLVItem *)QListViewItem::nextSibling();
}

void KPLVItem::toggleMark() 
{
  marked = ! marked;
  if (marked)
    setPixmap(1,info->interface->markInst);
  else
    setPixmap(1,info->interface->markUnInst);
}

void KPLVItem::setMark(bool mark) 
{
  marked = mark;
  if (mark)
    setPixmap(1,info->interface->markInst);
  else {
    if (info)
      setPixmap(1,info->interface->markUnInst);
  }
}

void KPLVItem::hide() 
{
  setHeight(0);
}

void KPLVItem::show() 
{
  setup();
}

int KPLVItem::compare( QListViewItem *i, int col, bool ascending ) const
{ // Make sorting more certain
  if (col == 2) { // size column
    QString k, j;

    j = key( col, ascending );
    j = j.replace(' ','0');
    j = j.rightJustify(6,'0');

    k = i->key( col, ascending );
    k = k.replace(' ','0');
    k = k.rightJustify(6,'0');

    //    kdDebug() << k <<"=" << j << "\n";
    return j.compare(k);
  } else {
    return  QListViewItem::compare(i, col, ascending);
  }
}

#include "kplview.moc"
