use ExtUtils::MakeMaker;
use Config;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

print "Trying to find some configuration information...\n";
my $kde_dirs = $ENV{KDEDIRS} || '/usr';
my $qt_dir = '/usr';
my $kde_inc = "$kde_dirs/include/kde";
my $kde_lib = "$kde_dirs/lib";
my $qt_inc = "$qt_dir/include/qt";
my $qt_lib = "$qt_dir/lib";
$kde_inc = undef unless -f "$kde_inc/dcopclient.h"; 
$kde_lib = undef unless -f "$kde_lib/libDCOP.$Config{dlext}";
$qt_dir = undef unless -f "$qt_inc/qglobal.h";

WriteMakefile(
    NAME	=> 'DCOP',
    VERSION_FROM => 'DCOP.pm',
    INC		=> "-I$qt_inc -I$kde_inc",
    LIBS	=> "-L$qt_lib -lqt -L$kde_lib -lkdecore -lDCOP",
    XS		=> {'DCOP.xs' => 'DCOP.cpp'},
    XSOPT	=> '-C++',
    CCFLAGS	=> '-x c++',
);

sub MY::xs_c {
    package MY;
    my $hack = shift->SUPER::xs_c(@_);
    $hack =~ s/\.c/.cpp/g;
    $hack;
}

