/***************************************************************************
                          KDEJavaSlot.cpp  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000-2001 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "KDEJavaSlot.moc"
#include <qtjava/QtSupport.h>
#include <kdejava/KDESupport.h>

/*
 Converts a Java type signature, from a signal or slot, to the corresponding C++ KDE type.
 Used to connect a Java slot to a signal emitted by the underlying C++ KDE instance.
 Note that all Java slots and signals are of type jobjectArray, and so no conversion is needed for them.
*/
static const char * const javaToQtTypeSignatureMap[][2] = {
	{"(int)",													"(int)"},
	{"(KAction)",												"(KAction*)"},
	{"(KAction,boolean)",										"(KAction*,bool)"},
	{"(KCompletionBase.KeyBindingType)",						"(KCompletionBase::KeyBindingType)"},
	{"(KDockWidget)",											"(KDockWidget*)"},
	{"(KDockWidget,KDockWidget)",								"(KDockWidget*,KDockWidget*)"},
	{"(KDockWidget,KDockWidget.DockPosition)",					"(KDockWidget*,KDockWidget::DockPosition)"},
	{"(int)",													"(KDualColorButton::DualColor)"},
	{"(KFileView)",												"(KFileView)"},
	{"(KGlobalSettings.Completion)",							"(KGlobalSettings::Completion)"},
	{"(KListView)",												"(KListView*)"},
	{"(KListView,QDropEvent)",									"(KListView*,QDropEvent*)"},
	{"(KListView,QDropEvent,QListViewItem)",					"(KListView*,QDropEvent*,QListViewItem*)"},
	{"(KListView,QDropEvent,QListViewItem,QListViewItem)",		"(KListView*,QDropEvent*,QListViewItem*,QListViewItem*)"},
	{"(KListView,QListViewItem)",								"(KListView*,QListViewItem*)"},
	{"(KListView,QListViewItem,QPoint)",						"(KListView*,QListViewItem*,const QPoint&)"},
	{"(KFileViewItem)",											"(const KFileViewItem*)"},
	{"(KURL)",													"(const KURL&)"},
	{"(KURL,KURL)",												"(const KURL&,const KURL&)"},
	{"(KURL,QPixmap)",											"(const KURL&,const QPixmap&)"},
	{"(KURL,ArrayList)",										"(const KURL::List&)"},
	{"(QPoint,ArrayList)",										"(const QPoint&, const QList<KFileItem>&)"},
	{"(Part)",													"(KParts::Part*)"},
	{"(KProcIO)",												"(KProcIO*)"},
	{"(KProcess)",												"(KProcess*)"},
	{"(KSpell)",												"(KSpell*)"},
	{"(KURLRequestor)",											"(KURLRequester*)"},
	{"(KXMLGUIClient)",											"(KXMLGUIClient*)"},
	{"(KXMLGUIClient,QPoint,java.util.ArrayList)",				"(KXMLGUIClient*,const QPoint&,const KFileItemList&)"},
	{"(DOMNode)",												"(const DOM::Node&)"},
	{"(Job)",													"(KIO::Job*)"},
	{"(Job,byte[])",											"(KIO::Job*,QByteArray&)"},
	{"(Job,JURL)",												"(KIO::Job*,const KURL&)"},
	{"(Job,KURL,KURL)",											"(KIO::Job*,const KURL&,const KURL&)"},
	{"(Job,KURL,KURL,bool,bool)",								"(KIO::Job*,const KURL&,const KURL&,bool,bool)"},
	{"(Job,KURL,String,KURL)",									"(KIO::Job*,const KURL&,const QString&,const KURL&)"},
	{"(Job,KURL,String,KURL)",									"(KIO::Job*,const KURL&,const QString&,const KURL&)"},
	{"(Job,byte[])",											"(KIO::Job*,const QByteArray&)"},
	{"(Job,String)",											"(KIO::Job*,const QString&)"},
	{"(Job,String,KURL)",										"(KIO::Job*,const QString&,const KURL&)"},
	{"(Job,long)",												"(KIO::Job*,unsigned long)"},
	{"(Slave)",													"(KIO::Slave*)"},
	{"(Slave,String)",											"(KIO::Slave*,int,const QString&)"}
};

KDEJavaSlot::KDEJavaSlot(jobject receiver, jstring slot)
	: JavaSlot(receiver, slot)
{
}

KDEJavaSlot::~KDEJavaSlot()
{
}


const char *
KDEJavaSlot::javaToQtSignalType(const char * signalName, const char * javaTypeSignature, QMetaObject * smeta)
{
static char qtSignalString[200];

	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0) {
			(void) sprintf(qtSignalString, "%s%s", signalName, javaToQtTypeSignatureMap[index][1]);
			
			if (smeta == 0 || smeta->signal(((const char *) qtSignalString + 1), TRUE) != 0) {
				return qtSignalString;
			}
		}
	}

	return JavaSlot::javaToQtSignalType(signalName, javaTypeSignature, smeta);
}

const char *
KDEJavaSlot::javaToQtSlotType(const char * javaTypeSignature, const char * signalString)
{
	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (	strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0
				&& (	signalString == 0
						|| QObject::checkConnectArgs(signalString, (const QObject *) 0, javaToQtTypeSignatureMap[index][1]) ) )
		{
			return javaToQtTypeSignatureMap[index][1];
		}
	}

	return JavaSlot::javaToQtSlotType(javaTypeSignature, signalString);
}

void
KDEJavaSlot::invoke(KAction* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KAction"));
}

void
KDEJavaSlot::invoke(KAction* arg1,bool arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KAction"), (jboolean) arg2);
}

void
KDEJavaSlot::invoke(KCompletionBase::KeyBindingType arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
}

void
KDEJavaSlot::invoke(KDockWidget* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"));
}

void
KDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.koala.KDockWidget") );
}

void
KDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget::DockPosition arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"), (jint) arg2);
}

void
KDEJavaSlot::invoke(KDualColorButton::DualColor arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
}

void
KDEJavaSlot::invoke(KGlobalSettings::Completion arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
}

void
KDEJavaSlot::invoke(KFileItem*arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem") );
}

void
KDEJavaSlot::invoke(const KFileViewItem*arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileViewItem") );
}

void
KDEJavaSlot::invoke(KListView*arg1,QDropEvent*arg2,QListViewItem*arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem") );
}

void
KDEJavaSlot::invoke(KListView*arg1,QDropEvent*arg2,QListViewItem*arg3,QListViewItem*arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem"),
									QtSupport::objectForQtKey(env, (void *) arg4, "org.kde.qt.QListViewItem") );
}

void
KDEJavaSlot::invoke(KListView*arg1,QListViewItem*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QListViewItem") );
}

void
KDEJavaSlot::invoke(KListView* arg1,QListViewItem* arg2,const QPoint& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QListViewItem"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.qt.QPoint") );
}

void
KDEJavaSlot::invoke(const KURL& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"));
}

void
KDEJavaSlot::invoke(const KURL& arg1, const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL") );
}

void
KDEJavaSlot::invoke(const KURL& arg1, const QPixmap& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPixmap") );
}

void
KDEJavaSlot::invoke(const KURL::List& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, KDESupport::arrayWithKURLList(env, (KURL::List *) &arg1));
}

void
KDEJavaSlot::invoke(const QPoint& arg1, const QList<KFileItem>& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.qt.QPoint"),
									KDESupport::arrayWithKFileItemList(env, (QList<KFileItem>*) &arg2) );
}

void
KDEJavaSlot::invoke(KProcIO* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KProcIO") );
}

void
KDEJavaSlot::invoke(KProcess* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KProcess") );
}

void
KDEJavaSlot::invoke(KSpell* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KSpell") );
}

void
KDEJavaSlot::invoke(KURLRequester* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KURLRequester") );
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient") );
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1,const QPoint& arg2,const KFileItemList& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPoint"),
									KDESupport::arrayWithKFileItemList(env, (QList<KFileItem>*) &arg1) );
}

void
KDEJavaSlot::invoke(const DOM::Node& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.DOMNode") );
}

void
KDEJavaSlot::invoke(KParts::Part* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Part") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,QByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;[B)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQByteArray(env, &arg2) );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3,bool arg4,bool arg5)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;ZZ)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL"),
									(jboolean) arg4,
									(jboolean) arg5 );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const QString& arg3,const KURL& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::fromQString(env, (QString *) &arg3),
									QtSupport::objectForQtKey(env, (void *) &arg4, "org.kde.koala.KURL") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;[B)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQByteArray(env, (QByteArray *) &arg2) );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQString(env, (QString *) &arg2) );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QString& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQString(env, (QString *) &arg2),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL") );
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,unsigned long arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Part"),
									(jlong) arg2 );
}

void
KDEJavaSlot::invoke(KIO::Slave* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Slave") );
}

void
KDEJavaSlot::invoke(KIO::Slave* arg1,int arg2,const QString& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;ILjava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Slave"),
									(jint) arg2,
									QtSupport::fromQString(env, (QString *) &arg3) );
}

KDEJavaSlotFactory::KDEJavaSlotFactory()
	: JavaSlotFactory()
{
}

JavaSlot *
KDEJavaSlotFactory::createJavaSlot(jobject receiver, jstring slot)
{
	return new KDEJavaSlot(receiver, slot);
}


