/***************************************************************************
                            Entry.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 Each entry in a loaded database has its own .Entry object.

  \par The structure of the address database
  As you might have read, kab uses the QConfigDB class to manage its
  data files. This class is intended to handle hierarchical structures.
  Thus, kab is able to create human readable but still deep and complex
  data files. This paragraph describes the overall structure of the
  files, the next two deal with special parts of it. <BR>
  First of all, kab II data files (that usually end with \c .kab, while in
  kab 1 the fixed file name was \c addressbook.database) have two main
  sections (see the documentation of the QConfigDB and Section classes),
  one is called \c config, it contains different file specific
  configuration settings like the last displayed entry, and one section
  called \c entries that in turn contains a subsection for each entry in
  the database file. The keys of this subsections are the literal strings
  that are used in the KabKey class in the member KabKey.key. Each entry
  subsection has some key-value-pairs described below and another
  subsection "addresses" with one or more addresses in it. See the
  following example for a kab II data file (without any key-value-pairs):
  <BR> <PRE>
  [config]
  [END]
  [entries]
     [1] (the first entry with literal key "1")
       [addresses]
         [1] (the first address, addresses are enumerated)
         [END]
         [2] (the second address)
         [END]
         ... (more addresses may follow)
       [END]
     [END]
     [2] (the second entry)
       [addresses]
         [1]
         [END]
       [END]
     [END]
     ... (more entries may follow)
  [END] </PRE> <BR>

  \par The fields an entry contains
  An entry contains all settings that are expected to be unique for all
  addresses directly as key-value-pairs. Everything that is part of a
  specific address of this person is part of an object of the member list
  \c addresses referenced in the next paragraph. <BR>
  The keys defined directly in the entry sections are: <DL>
  <DD> "title" The title of that person. </DD>
  <DD> "rank" A possible military rank of that person. </DD>
  <DD> "fn" The formatted name. If it is not empty, it replaces the
       standard combination of the other name fields in the address
       display. </DD>
  <DD> "nameprefix" A possible name prefix. </DD>
  <DD> "firstname" The first name. </DD>
  <DD> "middlename" The middle name. </DD>
  <DD> "lastname" The last name. </DD>
  <DD> "birthday" The birthday (a QDate). </DD>
  <DD> "comment" A free form comment. </DD>
  <DD> "talk" The talk addresses (a string list). </DD>
  <DD> "emails" The email addresses (a string list). </DD>
  <DD> "keywords" A list of free-form keywords. </DD>
  <DD> "telephone" A list of telephone numbers in a special format. </DD>
  <DD> "URLs" A list of internet addresses. </DD>
  <DD> "user_1" The first user-declared data field. </DD>
  <DD> "user_2" The second user-declared data field. </DD>
  <DD> "user_3" The third user-declared data field. </DD>
  <DD> "user_4" The fourth user-declared data field. </DD>
  </DL>
  See the next section for a description of the addresses subsections.

  \par The fields of the addresses subsections
  The section for each entry contains a subsection \c addresses with
  in turn a subsection for each address. The addresses are enumerated
  in the order they are inserted, their keys are the numbers of
  inserting converted to a string. <BR>
  The keys defined in an address subsection are: <DL>
  <DD> "headline" A headline shown for the address. </DD>
  <DD> "position" The position of the person. </DD>
  <DD> "org" The organisation. </DD>
  <DD> "orgunit" The organisational unit. </DD>
  <DD> "orgsubunit" The organisational subunit. </DD>
  <DD> "role" The role of the person. </DD>
  <DD> "deliverylabel" A label for delivering to this address. </DD>
  <DD> "address" The street, house no., flat etc line. </DD>
  <DD> "zip" A zip or postal code. </DD>
  <DD> "town" The town the person lives in in this address. </DD>
  <DD> "country" The country for federal states. </DD>
  <DD> "state" The state for federal states. </DD>

  \par The local configuration section
  For each kab II database file there are some settings that apply
  only to the file itselfes, not to all kab databases the user works
  with. These settings are called the local configuration. The settings
  are stored in the \c config section of the local file. The following
  keys are declared in this section: <DL>
  <DD> "user_1" The \e name of the first user-declared field. </DD>
  <DD> "user_2" The \e name of the second user-declared field. </DD>
  <DD> "user_3" The \e name of the third user-declared field. </DD>
  <DD> "user_4" The \e name of the fourth user-declared field. </DD>
  </DL>
  More fields will surely follow.

 @short  Each entry in a loaded database has its own ::Entry object.
*/
public class  Entry implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected Entry(Class dummy){}


/**  Use this method to retrieve the address at the given \a index.
  The method is provided for convenience. The address data is
  returned in \a address. 
*/
	public native int getAddress( int index, Address address);

/**  Returns the number of addresses of this entry. 
*/
	public native int noOfAddresses();

/**  Query the literal, translated name of the field given by its
	key. 

*/
	public native int get( String key, QVariant arg1);
}
