/***************************************************************************
                            KCodecs.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A wrapper class for the most commonly used encoding and
 decoding algorithms.  Currently there is support for encoding
 and decoding input using base64, uu and the quoted-printable
 specifications.

 The convienence functions are well suited for encoding
 and decoding a relatively small input.

 <PRE>
 QCString input = "Aladdin:open sesame";
 QCString result = KCodecs.base64Encode(input);
 printf ("Result: %c", result.data());

 Output should be
 Result: QWxhZGRpbjpvcGVuIHNlc2FtZQ==
 </PRE>

 @author Rik Hemsley <rik@kde.org>
 
 @short A collection of commonly used encoding and decoding algorithms.

*/
public class  KCodecs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCodecs(Class dummy){}


/** 
 Encodes the given data using the quoted-printable algorithm.
 Equivalent to quotedPrintableEncode(in, true).

*/
	public static native String quotedPrintableEncode( byte[] in);

/** 
 Encodes the given data using the quoted-printable algorithm.

*/
	public static native String quotedPrintableEncode( byte[] in, boolean useCRLF);

/** 
 Decodes a quoted-printable encoded string.
 Accepts data with CRLF or standard unix line breaks

*/
	public static native byte[] quotedPrintableDecode( String in);

/** 
 Encodes the given data using the uuencode algorithm.

 The output is split into lines starting with the number of
 encoded octets in the line and ending with a newline.  No
 line is longer than 45 octets (60 characters), excluding the
 line terminator.

*/
	public static native String uuencode( byte[] in);

/** 
 Encodes the given data using the uuencode algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>NOTE:</u> the output array is always first reset for
 sanity and then resized appropriatly.  Hence, any data
 that is present in the output array will be lost.

*/
	public static native void uuencode( byte[] in, byte[] out);

/** 
 Encodes the given string using the uuencode algorithm.

*/
	public static native String uuencode( String str);

/** 
 Decodes the given data using the uuencode algorithm.

 Any 'begin' and 'end' lines liks those generated by
 nix utilities will automatically be ignored.

*/
	public static native String uudecode( byte[] in);

/** 
 Decodes the given data using the uudecode algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 Any 'begin' and 'end' lines liks those generated by
 nix utilities will automatically be ignored.

 <u>IMPORTANT:</u> the output array is first reset and then
 resized appropriately.  Hence, any data that is present in
 the output array will be lost.

*/
	public static native void uudecode( byte[] in, byte[] out);

/** 
 Decodes a uuencoded string.

*/
	public static native String uudecode( String str);

/** 
 Encodes the given data using the base64 algorithm.

 The boolean argument determines if the encoded data is
 going to be restricted to 76 characters or less per line
 as specified by RFC 2045.  If <code>insertLFs</code> is true, then
 there will be 76 characters or less per line.

*/
	public static native String base64Encode( byte[] in, boolean insertLFs);

/** 

 Use {@link #base64Encode}
 with the boolean argument set to false.
   
*/
	public static native String base64Encode( byte[] in);

/** 
 Encodes the given data using the base64 algorithm.

 Use this function whenever you are dealing with very
 large data or a stream of data.  The boolean argument
 determines if the encoded data is going to be restricted
 to 76 characters or less per line as specified by RFC 2045.
 If <code>insertLFs</code> is true, then there will be 76 characters or
 less per line.

 <u>NOTE:</u> the output array is always first reset for
 sanity and then resized appropriatly.  Hence, any data
 that is present in the output array will be lost.

*/
	public static native void base64Encode( byte[] in, byte[] out, boolean insertLFs);

/** 

 Use {@link #base64Encode}
 with the boolean argument set to false.
   
*/
	public static native void base64Encode( byte[] in, byte[] out);

/** 
 Encodes the given string using the base64 algorithm.

 The boolean argument determines if the encoded data is
 going to be restricted to 76 characters or less per line
 as specified by RFC 2045.  If <code>insertLFs</code> is true, then
 there will be 76 characters or less per line.

*/
	public static native String base64Encode( String str, boolean insertLFs);

/** 

 Use {@link #base64Encode}
 with the boolean argument set to false.
   
*/
	public static native String base64Encode( String str);

/** 
 Decodes the given data that was encoded using the
 base64 algorithm.

*/
	public static native String base64Decode( byte[] in);

/** 
 Decodes the given data that was encoded with the base64
 algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array and cut down the number of
 copy opertation that have to be performed in the process.

 <u>IMPORTANT:</u> the output array is first reset and then
 resized appropriately.  Hence, any data that is present in
 the output array will be lost.

*/
	public static native void base64Decode( byte[] in, byte[] out);

/** 
 Decodes a string encoded with the base64 algorithm.

*/
	public static native String base64Decode( String str);

/** 
 Encodes the String data using the base64 algorithm.

 <u>NOTE:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 encoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String base64Encode( String str);

/** 
 Decodes the encoded String data using the base64 algorithm.

 <u>NOTE:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 decoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String base64Decode( String str);

/** 
 Encodes the String data using the uuencode algorithm.

 <u>NOTE:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 encoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String uuencode( String str);

/** 
 Decodes the String data using the uuencode algorithm.

 <u>NOTE:</u> This function is ONLY provided for convenience
 and backward compatability!  Using it can result in an incorrectly
 decoded data since the conversion of the String input to latin-1
 can and will result in data loss if the input data contains non-
 latin1 characters.  As such it is highly recommended that you avoid
 this function unless you are absolutely certain that your input
 does not contain any non-latin1 character!!
   
*/
//	public static native String uudecode( String str);

/** 

   
*/
	public static native String encodeString( String data);

/** 

   
*/
	public static native String decodeString( String data);
}
