package org.kde.koala;
import org.kde.qt.*;


/** {@link KComboBox} emits these signals */
public interface KComboBoxSignals {

/** 
 Emitted when the user changed the completion mode by using the
 popupmenu.
     
*/
	void completionModeChanged( int arg1 );
	void destroyed();

/** 
 Emitted when the user presses
 the Enter key.

 The argument is the current
 text being edited.  This signal is just like
 {@link KComboBox#returnPressed} except it contains the
 current text as its argument.

 Note that this signal is only emitted if this
 widget is editable.
    
*/
	void returnPressed( String arg1 );
	void activated( String arg1 );
	void highlighted( String arg1 );

/** 
 Emitted when the text rotation key-bindings are pressed.

 The argument indicates which key-binding was pressed.
 In this case this can be either one of four values:
 <code>PrevCompletionMatch</code>, <code>NextCompletionMatch</code>, <code>RotateUp</code> or
 <code>RotateDown.</code> See {@link KCompletionBase#setKeyBinding} for
 details.

 Note that this signal is <em>NOT</em> emitted if the completion
 mode is set to CompletionNone.
    
*/
//	void textRotation( KCompletionBase_KeyBindingType arg1 );

/** 
 Emitted before the context menu is displayed.

 The signal allows you to add your own entries into the
 the context menu that is created on demand.

 NOTE: Do not store the pointer to the QPopupMenu
 provided through since it is created and deleted
 on demand.

*/
	void aboutToShowContextMenu( QPopupMenu arg1 );

/** 
 This signal is emitted when the completion key
 is pressed.

 The argument is the current text
 being edited.

 Note that this signal is <em>not</em> available if this
 widget is non-editable or the completion mode is
 set to <code>KGlobalSettings.CompletionNone.</code>
    
*/
	void completion( String arg1 );
	void textChanged( String arg1 );
}

