/***************************************************************************
                            KDirOperator.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This widget works as a network transparent filebrowser. You specify a URL
 to display and this url will be loaded via {@link KDirLister}. The user can
 browse through directories, highlight and select files, delete or rename
 files.

 It supports different views, e.g. a detailed view (see @KFileDetailView),
 a simple icon view (see @KFileIconView), a combination of two views,
 separating directories and files (@see KCombiView).

 Additionally, a preview view is available (see @KFilePreview), which can
 show either a simple or detailed view and additionally a preview widget
 (see {@link #setPreviewWidget}). {@link KImageFilePreview} is one implementation
 of a preview widget, that displays previews for all supported filetypes
 utilizing KIO.PreviewJob.

 Currently, those classes don't support Drag&Drop out of the box -- there
 you have to use your own view-classes. You can use some DnD-aware views
 from Bjrn Sahlstrm <bjorn@kbear.org> until they will be integrated
 into this library. See http://master.kde.org/~pfeiffer/DnD-classes.tar.gz

 This widget is the one used in the KFileDialog.

 Basic usage is like this:
 <pre>
   KDirOperator op = new KDirOperator( KURL( "file:/home/gis" ), this );
   // some signals you might be interested in
   connect(op, SIGNAL("updateInformation(int, int)"),
           SLOT("updateStatusLine(int, int)"));
   connect(op, SIGNAL("urlEntered(const KURL&)"),
           SLOT("urlEntered(const KURL&)"));
   connect(op, SIGNAL("fileHighlighted(const KFileViewItem )"),
           SLOT("fileHighlighted(const KFileViewItem )"));
   connect(op, SIGNAL("fileSelected(const KFileViewItem )"),
           SLOT("fileSelected(const KFileViewItem )"));
   connect(op, SIGNAL("finishedLoading()"),
           SLOT("slotLoadingFinished()"));

   op.readConfig( KGlobal.config(), "Your KDiroperator ConfigGroup" );
   op.setView(KFile.Default);
 </pre>

 This will create a childwidget of 'this' showing the directory contents
 of /home/gis in the default-view. The view is determined by the readConfig()
 call, which will read the KDirOperator settings, the user left your program
 with (and which you saved with op.saveConfig()).

 See {@link KDirOperatorSignals} for signals emitted by KDirOperator.

 See {@link KDirOperatorEventHandling} for event handlers to override in subclasses of KDirOperator.

 @author Stephan Kulow <coolo@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget for displaying files and browsing directories.

*/
public class KDirOperator extends QWidget  {
	protected KDirOperator(Class dummy){super((Class) null);}


/** 
 Constructs the KDirOperator with no initial view. As the views are
 configurable, call {@link #readConfig} to load the user's configuration
 and then {@link setView} to explicitly set a view.

 This constructor doesn't start loading the url, {@link setView} will do it.
     
*/
	private native void newKDirOperator( KURL urlName, QWidget parent, String name);
	public KDirOperator( KURL urlName, QWidget parent, String name) {
		super((Class) null);
		newKDirOperator( urlName, parent, name);
	}
	private native void newKDirOperator();
	public KDirOperator() {
		super((Class) null);
		newKDirOperator();
	}

/** 
 Destroys the KDirOperator.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Enable/disable showing hidden files.
     
*/
	public native void setShowHiddenFiles( boolean s);

/** 

*/
	public native boolean showHiddenFiles();

/** 
 Stops loading immediately. You don't need to call this, usually.
     
*/
	public native boolean close();

/** 
 Set a filter like ".cpp .h .o". Only files matching that filter
 will be shown. Call {@link #rereadDir} to apply it.

*/
	public native void setNameFilter( String filter);

/** 

*/
	public native String nameFilter();

/** 
 Sets a list of mimetypes as filter. Only files of those mimetypes
 will be shown.

 Example:
 <pre>
 StringList filter;
 filter << "text/html" << "image/png" << "inode/directory";
 dirOperator.setMimefilter( filter );
 </pre>

 Node: Without the mimetype inode/directory, only files would be shown.

*/
	public native void setMimeFilter( String[] mimetypes);
	public native ArrayList mimeFilter();

/** 
 Clears both the namefilter and mimetype filter, so that all files and
 directories will be shown.

*/
	public native void clearFilter();

/** 

*/
	public native KURL url();

/** 
 Sets a new url to list.

*/
	public native void setURL( KURL url, boolean clearforward);

/** 
 Clears the current selection and attempts to set <code>filename</code>
 the current file. filename is just the name, no path or url.
     
*/
	public native void setCurrentItem( String filename);

/** 
 Sets a new KFileView to be used for showing and browsing files.
 Note: this will read the current {@link #url} to fill the view.

*/
	public native void setView( KFileViewInterface view);

/** 

*/
	public native KFileViewInterface view();

/** 
 Returns the widget of the current view. null if there is no view/widget.
 (KFileView itself is not a widget.)
     
*/
	public native QWidget viewWidget();

/** 
 Sets one of the predefine fileviews

*/
	public native void setView( int view);

/** 
 Sets the way to sort files and directories.
     
*/
	public native void setSorting( int arg1);

/** 

*/
	public native int sorting();

/** 

*/
	public native boolean isRoot();

/** 

*/
	public native KFileReader fileReader();

/** 

*/
	public native KProgress progressBar();

/** 
 Sets the listing/selection mode for the views, an OR'ed combination of

 You cannot mix File and Files of course, as the former means
 single-selection mode, the latter multi-selection.
     
*/
	public native void setMode( int m);
	public native int mode();

/** 
 Sets a preview-widget to be shown next to the file-view.
 The ownership of <code>w</code> is transferred to KDirOperator, so don't
 delete it yourself!
     
*/
	public native void setPreviewWidget( QWidget w);

/** 

*/
	public native ArrayList selectedItems();

/** 

*/
	public native boolean isSelected( KFileViewItem item);

/** 

*/
	public native int numDirs();

/** 

*/
	public native int numFiles();

/** 

*/
	public native KCompletion completionObject();

/** 

*/
	public native KCompletion dirCompletionObject();

/** 
 an accessor to a collection of all available Actions. The actions
 are static, they will be there all the time (no need to connect to
 the signals KActionCollection.inserted() or removed().

 There are the following actions:

 The short and detailed view are in an exclusive group. The sort-by
 actions are in an exclusive group as well. Also the "separate dirs",
 "preview" and "single" actions are in an exclusive group.

 You can e.g. use
 <pre>actionCollection().action( "up" ).plug( someToolBar );</pre>
 to add a button into a toolbar, which makes the dirOperator change to
 its parent directory.

*/
	public native KActionCollection actionCollection();

/** 
 Reads the default settings for a view, i.e. the default KFile.FileView.
 Also reads the sorting and whether hidden files should be shown.
 Note: the default view will not be set - you have to call
 <pre>{@link #setView}</pre> to apply it.

*/
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);

/** 
 Saves the current settings like sorting, simple or detailed view.

*/
	public native void saveConfig( KConfig arg1, String group);
	public native void saveConfig( KConfig arg1);

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 The default is false, set it to true if you don't want files selected
 with single click.
     
*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	public native boolean onlyDoubleClickSelectsFiles();

/** 
 Creates the given directory/url. If it is a relative path,
 it will be completed with the current directory.
 If enterDirectory is true, the directory will be entered after a
 successful operation. If unsuccessful, a messagebox will be presented
 to the user.

*/
	public native boolean mkdir( String directory, boolean enterDirectory);
	public native boolean mkdir( String directory);

/** 
 Starts and returns a {@link KIO#DeleteJob} to delete the given <code>items.</code>

*/
	public native DeleteJob del( ArrayList items, boolean ask, boolean showProgress);
	public native DeleteJob del( ArrayList items);

/** 
 Clears the forward and backward history.
     
*/
	public native void clearHistory();

/** 
 When going up in the directory hierarchy, KDirOperator can highlight
 the directory that was just left.

 I.e. when you go from /home/gis/src to /home/gis, the item "src" will
 be made the current item.

 Default is off.
     
*/
	public native void setEnableDirHighlighting( boolean enable);

/** 

 Default is false.
     
*/
	public native boolean dirHighlighting();

/** 
 Goes one step back in the history and opens that url.
     
*/
	public native void back();

/** 
 Goes one step forward in the history and opens that url.
     
*/
	public native void forward();

/** 
 Enters the home directory.
     
*/
	public native void home();

/** 
 Goes one directory up from the current url.
     
*/
	public native void cdUp();

/** 
 Re-reads the current url.
     
*/
	public native void rereadDir();

/** 
 Opens a dialog to create a new directory.
     
*/
	public native void mkdir();

/** 
 Deletes the currently selected files/directories.
     
*/
	public native void deleteSelected();

/** 
 Enables/disables actions that are selection dependent. Call this e.g.
 when you are about to show a popup menu using some of KDirOperators
 actions.
     
*/
	public native void updateSelectionDependentActions();

/** 
 Tries to complete the given string (only completes files).
     
*/
	public native String makeCompletion( String arg1);

/** 
 Tries to complete the given string (only completes directores).
     
*/
	public native String makeDirCompletion( String arg1);

/** 
 Sets a custom KFileReader to list directories.
     
*/
	protected native void setFileReader( KFileReader reader);

/** 
 Sets up all the actions. Called from the constructor, you usually
 better not call this.
     
*/
	protected native void setupActions();

/** 
 Updates the sorting-related actions to comply with the current sorting

*/
	protected native void updateSortActions();

/** 
 Updates the view-related actions to comply with the current
 KFile.FileView
     
*/
	protected native void updateViewActions();

/** 
 Sets up the context-menu with all the necessary actions. Called from the
 constructor, you usually don't need to call this.
     
*/
	protected native void setupMenu();

/** 
 Synchronizes the completion objects with the entries of the
 currently listed url.

 Automatically called from {@link #makeCompletion} and
 {@link #makeDirCompletion}
     
*/
	protected native void prepareCompletionObjects();

/** 
 Checks if there support from {@link KIO#PreviewJob} for the currently
 shown files, taking {@link #mimeFilter} and {@link #nameFilter} into account
 Enables/disables the preview-action accordingly.
     
*/
	protected native boolean checkPreviewSupport();

/** 
 Restores the normal cursor after showing the busy-cursor. Also hides
 the progressbar.
     
*/
	protected native void resetCursor();

/** 

     
*/
	protected native void readNextMimeType();

/** 
 Called after {@link #setURL} to load the directory, update the history,
 etc.
     
*/
	protected native void pathChanged();

/** 

     
*/
	protected native void filterChanged();

/** 
 Adds a new list of KFileItems to the view
 (coming from KFileReader/KDirLister)
     
*/
	protected native void insertNewFiles( ArrayList newone);

/** 
 Removes the given KFileItem item from the view (usually called from
 KFileReader/KDirLister).
     
*/
	protected native void itemDeleted( KFileItem arg1);

/** 
 Enters the directory specified by the given <code>item.</code>
     
*/
	protected native void selectDir( KFileViewItem item);

/** 
 Emits fileSelected( item )
     
*/
	protected native void selectFile( KFileViewItem item);

/** 
 Emits fileHighlighted( i )
     
*/
	protected native void highlightFile( KFileViewItem i);

/** 
 Called upon right-click to activate the popupmenu.
     
*/
	protected native void activatedMenu( KFileViewItem arg1);

/** 
 Changes sorting to sort by name
     
*/
	protected native void sortByName();

/** 
 Changes sorting to sort by size
     
*/
	protected native void sortBySize();

/** 
 Changes sorting to sort by date
     
*/
	protected native void sortByDate();

/** 
 Changes sorting to reverse sorting
     
*/
	protected native void sortReversed();

/** 
 Toggles showing directories first / having them sorted like files.
     
*/
	protected native void toggleDirsFirst();

/** 
 Toggles case sensitive / case insensitive sorting
     
*/
	protected native void toggleIgnoreCase();

/** 

*/
	protected native boolean dirOnlyMode();

/** 
 <code>internal</code>
     
*/
	protected native void deleteOldView();

/** 
 Tries to make the given <code>match</code> as current item in the view and emits
 completion( match )
     
*/
	protected native void slotCompletionMatch( String match);
}
