package org.kde.koala;
import org.kde.qt.*;


/** {@link KDockWidget} emits these signals */
public interface KDockWidgetSignals {

/** 
 Signals that the dock default position is set.
   
*/
	void setDockDefaultPos();
	void destroyed();

/** 
 Signals that the close button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerCloseButtonClicked();

/** 
 Emits that another dockwidget is docking to this.

*/
	void docking( KDockWidget dw, int dp );

/** 
 Signals that the widget processes a close event.
   
*/
	void iMBeingClosed();

/** 
 Signals that the dockback button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerDockbackButtonClicked();

/** 
 Signals that the widget is undocked now.
   
*/
	void hasUndocked();
}

