/***************************************************************************
                            KFontChooser.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A widget for interactive font selection.

 While {@link KFontChooser} as an ordinary widget can be embedded in
 custom dialogs and therefore is very flexible, in most cases
 it is preferable to use the convenience functions in
 {@link KFontDialog}.

 See {@link KFontChooserSignals} for signals emitted by KFontChooser.

 See {@link KFontChooserEventHandling} for event handlers to override in subclasses of KFontChooser.

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontChooser.java,v 1.2.2.2 2001/09/02 22:10:35 rdale Exp $
 
 @short A font selection widget.

*/
public class KFontChooser extends QWidget  {
	protected KFontChooser(Class dummy){super((Class) null);}


/** 
 Constructs a font picker widget.

*/
	private native void newKFontChooser( QWidget parent, String name, boolean onlyFixed, String[] fontList, boolean makeFrame, int visibleListSize);
	public KFontChooser( QWidget parent, String name, boolean onlyFixed, String[] fontList, boolean makeFrame, int visibleListSize) {
		super((Class) null);
		newKFontChooser( parent, name, onlyFixed, fontList, makeFrame, visibleListSize);
	}
	public KFontChooser( QWidget parent, String name) {
		this( parent, name, false, new String[0], true, 8);
	}
	public KFontChooser( QWidget parent) {
		this( parent, null, false, new String[0], true, 8);
	}
	private native void newKFontChooser();
	public KFontChooser() {
		super((Class) null);
		newKFontChooser();
	}
	protected native void finalize() throws InternalError;

/** 
 Enable or disable a font column in the chooser.

 Use this
 function if your application does not need or supports all font
 properties.

*/
	public native void enableColumn( int column, boolean state);

/** 
 Set the currently selected font in the chooser.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native QFont font();

/** 
 Set the color to use in the preview
   
*/
	public native void setColor( QColor col);

/** 

*/
	public native QColor color();

/** 
 Set the currently selected charset in the chooser.
   
*/
	public native void setCharset( String charset);

/** 

*/
	public native String charset();

/** 

*/
	public native String sampleText();

/** 
 Set the sample text.

 Normally you should not change this
 text, but it can be better to do this if the default text is
 too large for the edit area when using the default font of your
 application.

*/
	public native void setSampleText( String text);

/** 
 Reimplemented for internal reasons.
   
*/
	public native QSize sizeHint();

/** 
 Convert a {@link QFont} into the corresponding X Logical Font
 Description (XLFD).

*/
	public static native String getXLFD( QFont theFont);

/** 
 Create a list of font strings that match <code>pattern.</code>

*/
	public static native void getFontList( String[] list, String pattern);

/** 
 Create a list of font strings.

*/
	public static native void getFontList( String[] list, boolean fixed);
	public static final int FamilyList = 0x01;
	public static final int StyleList = 0x02;
	public static final int SizeList = 0x04;
	public static final int CharsetList = 0x08;
}
