/***************************************************************************
                            KFontCombo.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combobox that lists the available fonts.

 The items are painted using the respective font itself, so the user
 can easily choose a font based on its look. This can be turned off
 globally if the user wishes so.

 See {@link KFontComboSignals} for signals emitted by KFontCombo.

 See {@link KFontComboEventHandling} for event handlers to override in subclasses of KFontCombo.

 @author Malte Starostik <malte.starostik@t-online.de>

 @version $Id: KFontCombo.java,v 1.1.2.1 2001/08/29 23:14:09 rdale Exp $
 
 @short A combobox to choose a font.
*/
public class KFontCombo extends KComboBox  {
	protected KFontCombo(Class dummy){super((Class) null);}


/** 
 Constructor

*/
	private native void newKFontCombo( QWidget parent, String name);
	public KFontCombo( QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( parent, name);
	}
	private native void newKFontCombo( QWidget parent);
	public KFontCombo( QWidget parent) {
		super((Class) null);
		newKFontCombo( parent);
	}

/** 
 Constructor that takes an already initialzed font list

*/
	private native void newKFontCombo( String[] fonts, QWidget parent, String name);
	public KFontCombo( String[] fonts, QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( fonts, parent, name);
	}
	private native void newKFontCombo( String[] fonts, QWidget parent);
	public KFontCombo( String[] fonts, QWidget parent) {
		super((Class) null);
		newKFontCombo( fonts, parent);
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 Sets the font list

*/
	public native void setFonts( String[] fonts);

/** 
 Set the listed fonts to bold or normal

*/
	public native void setBold( boolean bold);

/** 
 Retrieve the current bold status

*/
	public native boolean bold();

/** 
 Set the listed fonts to italic or regular

*/
	public native void setItalic( boolean bold);

/** 
 Retrieve the current italic status

*/
	public native boolean italic();

/** 
 Set the listed fonts to underlined or not underlined

*/
	public native void setUnderline( boolean bold);

/** 
 Retrieve the current underline status

*/
	public native boolean underline();

/** 
 Set the listed fonts to striked out or not

*/
	public native void setStrikeOut( boolean bold);

/** 
 Retrieve the current strike out status

*/
	public native boolean strikeOut();

/** 
 Set the listed fonts' size

*/
	public native void setSize( int size);

/** 
 Retrieve the current font size

*/
	public native int fontSize();

/** 
 Retrieve the user's setting of whether the items should be painted
 in the respective fonts or not

*/
	public static native boolean displayFonts();

/** 
 Updated the combo's {@link #listBox} to reflect changes made to the
 fonts' attributed
     
*/
	protected native void updateFonts();
}
