/***************************************************************************
                            KIconButton.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A pushbutton for choosing an icon. Pressing on the button will open a
 KIconDialog for the user to select an icon. The current icon will be
 displayed on the button.
 
 See {@link KIconButtonSignals} for signals emitted by KIconButton.

 See {@link KIconButtonEventHandling} for event handlers to override in subclasses of KIconButton.

 @short 
 A pushbutton for choosing an icon.
*/
public class KIconButton extends QPushButton  {
	protected KIconButton(Class dummy){super((Class) null);}


/**  Creates a new KIconButton. Uses the global iconloader. 
*/
	private native void newKIconButton( QWidget parent, String name);
	public KIconButton( QWidget parent, String name) {
		super((Class) null);
		newKIconButton( parent, name);
	}
	private native void newKIconButton();
	public KIconButton() {
		super((Class) null);
		newKIconButton();
	}

/**  Alternate constructor for use with a different iconloader. 
*/
	private native void newKIconButton( KIconLoader loader, QWidget parent, String name);
	public KIconButton( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconButton( loader, parent, name);
	}
	private native void newKIconButton( KIconLoader loader, QWidget parent);
	public KIconButton( KIconLoader loader, QWidget parent) {
		super((Class) null);
		newKIconButton( loader, parent);
	}
	protected native void finalize() throws InternalError;

/** 
 Set a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in setIconType are allowed,
 and only icons of that size will be shown in the icon dialog.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Set the icon group and context. Use KIcon.NoGroup if you want to
 allow icons for any group in the given context.
     
*/
	public native void setIconType( int group, int context, boolean user);
	public native void setIconType( int group, int context);

/**  Set the button's initial icon. 
*/
	public native void setIcon( String icon);

/**  Reset the icon (reverts to an empty button) 
*/
	public native void resetIcon();

/**  Returns the selected icon name. 
*/
	public native String iconName();
}
