/***************************************************************************
                            KIconDialog.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog for interactive selection of icons. Use the function
 selectIcon() let the user select an icon.
 
 See {@link KIconDialogSignals} for signals emitted by KIconDialog.

 See {@link KIconDialogEventHandling} for event handlers to override in subclasses of KIconDialog.

 @short 
 Dialog for interactive selection of icons.
*/
public class KIconDialog extends KDialogBase  {
	protected KIconDialog(Class dummy){super((Class) null);}


/**  Construct the iconloader dialog. Uses the global iconloader. 
*/
	private native void newKIconDialog( QWidget parent, String name);
	public KIconDialog( QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( parent, name);
	}
	private native void newKIconDialog();
	public KIconDialog() {
		super((Class) null);
		newKIconDialog();
	}

/**  Alternate constructor to use a different iconloader. 
*/
	private native void newKIconDialog( KIconLoader loader, QWidget parent, String name);
	public KIconDialog( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( loader, parent, name);
	}
	private native void newKIconDialog( KIconLoader loader);
	public KIconDialog( KIconLoader loader) {
		super((Class) null);
		newKIconDialog( loader);
	}
	protected native void finalize() throws InternalError;

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in selectIcon are shown.
 When false, icons not available at the desired group's size will
 also be selectable.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Pops up the dialog an lets the user select an icon.

*/
	public native String selectIcon( int group, int context, boolean user);
}
