/***************************************************************************
                            KOpenWithDlg.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 "Open with" dialog box.
 Used automatically by KRun, and used by libkonq.

 See {@link KOpenWithDlgSignals} for signals emitted by KOpenWithDlg.

 See {@link KOpenWithDlgEventHandling} for event handlers to override in subclasses of KOpenWithDlg.

 @author David Faure <faure@kde.org>
 
 @short 
 "Open with" dialog box.
*/
public class KOpenWithDlg extends QDialog  {
	protected KOpenWithDlg(Class dummy){super((Class) null);}


/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	private native void newKOpenWithDlg( ArrayList urls, QWidget parent);
	public KOpenWithDlg( ArrayList urls, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( urls, parent);
	}
	private native void newKOpenWithDlg( ArrayList urls);
	public KOpenWithDlg( ArrayList urls) {
		super((Class) null);
		newKOpenWithDlg( urls);
	}

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	private native void newKOpenWithDlg( ArrayList urls, String text, String value, QWidget parent);
	public KOpenWithDlg( ArrayList urls, String text, String value, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( urls, text, value, parent);
	}
	private native void newKOpenWithDlg( ArrayList urls, String text, String value);
	public KOpenWithDlg( ArrayList urls, String text, String value) {
		super((Class) null);
		newKOpenWithDlg( urls, text, value);
	}

/** 
 Create a dialog to select a service for a given service type.
 Note that this dialog doesn't apply to URLs.

*/
	private native void newKOpenWithDlg( String serviceType, String value, QWidget parent);
	public KOpenWithDlg( String serviceType, String value, QWidget parent) {
		super((Class) null);
		newKOpenWithDlg( serviceType, value, parent);
	}
	private native void newKOpenWithDlg( String serviceType, String value);
	public KOpenWithDlg( String serviceType, String value) {
		super((Class) null);
		newKOpenWithDlg( serviceType, value);
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;

/** 

*/
	public native String text();

/** 

*/
//	public native KService_Ptr service();

/** 
 The slot for clearing the edit widget
    
*/
	public native void slotClear();
	public native void slotSelected( String _name, String _exec);
	public native void slotHighlighted( String _name, String _exec);
	public native void slotTextChanged();
	public native void slotTerminalToggled( boolean arg1);
	public native void slotDbClick();
	public native void slotOK();

/** 
 Determine service type from URLs
     
*/
	protected native void setServiceType( ArrayList _urls);

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
	protected native void init( String text, String value);

/** 
 Reimplemented from QDialog.accept() to save history of the combobox
     
*/
	protected native void accept();
}
