/***************************************************************************
                            KPixmapSplitter.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you have a pixmap containing several items (icons), you can use this
 class to get the coordinates of each item.

 For example, if you have a pixmap with 25 items and you want to get the
 4th item as a pixmap (every item being 20x10 pixels):
 <pre>
 KPixmapSplitter splitter;
 splitter.setPixmap( somePixmap );
 splitter.setItemSize( QSize( 20, 10 ));

 QPixmap item( 20, 10 );
 item.fill( Qt.white );
 QRect rect = splitter.coordinates( 4 );
 if ( !rect.isEmpty() )
     bitBlt( &item, QPoint(0,0), &somePixmap, rect, CopyROP );

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A class to split a pixmap into several items.

*/
public class  KPixmapSplitter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPixmapSplitter(Class dummy){}


/** 
 Constructor, does nothing but initializing some default-values.
     
*/
	private native void newKPixmapSplitter();
	public KPixmapSplitter() {
		newKPixmapSplitter();
	}
	protected native void finalize() throws InternalError;

/** 
 Set the pixmap to be splitted.
     
*/
	public native void setPixmap( QPixmap pixmap);

/** 

*/
	public native QPixmap pixmap();

/** 
 Set the size of the items you want to get out of the given pixmap.
 The QRect of {@link coordinate} will have the width and height of exactly
 this <code>size.</code>
     
*/
	public native void setItemSize( QSize size);

/** 

*/
	public native QSize itemSize();

/** 
 If there is space between rows in the given pixmap, you have to specify
 how many pixels there are.
     
*/
	public native void setVSpacing( int spacing);

/** 
 If there is space between columns in the given pixmap, you have to
 specify how many pixels there are.
     
*/
	public native void setHSpacing( int spacing);

/** 

*/
	public native QRect coordinates( int pos);

/** 
 Overloaded for convenience. Returns the item at the position of the
 given character (when using a latin1 font-pixmap)
     
*/
	public native QRect coordinates( char ch);
}
