/***************************************************************************
                            KRandomSequence.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A class to create a pseudo-random sequence

 Given a seed number, this class will produce a sequence of
 pseudo-random numbers.  This would typically be used in
 applications like games.

 In general, you should instantiate a KRandomSequence object and
 pass along your seed number in the constructor.  From then on,
 simply call {@link getDouble} or {@link getLong} to obtain the next
 number in the sequence.

 @author Sean Harmer <sh@astro.keele.ac.uk>
 
 @short 
 A class to create a pseudo-random sequence

*/
public class  KRandomSequence implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRandomSequence(Class dummy){}


/** 
 Creates a pseudo-random sequence based on the seed lngSeed.

 If lngSeed is 0, the sequence is initialized with a value from
 kapp.random().

 A Pseudo-random sequence is different for each seed but can be 
 reproduced by starting the sequence with the same seed.

 If you need a single value which needs to be unpredictable, 
 you need to use kapp.random() instead.

   
*/
	private native void newKRandomSequence( long lngSeed);
	public KRandomSequence( long lngSeed) {
		newKRandomSequence( lngSeed);
	}
	private native void newKRandomSequence();
	public KRandomSequence() {
		newKRandomSequence();
	}

/** 
 Standard destructor
   
*/
	protected native void finalize() throws InternalError;

/** 
 Restart the sequence based on lngSeed
   
*/
	public native void setSeed( long lngSeed);
	public native void setSeed();

/** 
 Get the next number from the pseudo-random sequence

*/
	public native double getDouble();

/** 
 Get the next number from the pseudo-random sequence

*/
	public native long getLong( long max);

/** 
 Get a boolean from the pseudo-random sequence

*/
	public native boolean getBool();

/** 
 Put a list in random order

*/
//	public native void randomize( QGList list);
}
