/***************************************************************************
                            KRun.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 To open files with their associated applications in KDE, use KRun.

 It can execute any desktop entry, as well as any file, using
 the default application or another application "bound" to the file type.

 You need to create an instance of KFileOpenWithHandler before,
 so that in case the mime-type of the file is unknown, or if there is
 no application associated, KRun will bring up the "open with" dialog.
 Example:
 KFileOpenWithHandler fowh;
 new KRun( url );

 In that example, the mimetype of the file is not known by the application,
 so a KRun instance must be created. It will determine the mimetype by itself.
 If the mimetype is known, or if you even know the service (application) to
 use for this file, use one of the static methods.

 See {@link KRunSignals} for signals emitted by KRun.

 See {@link KRunEventHandling} for event handlers to override in subclasses of KRun.

 @short Opens files with their associated applications in KDE.
*/
public class KRun extends QObject  {
	protected KRun(Class dummy){super((Class) null);}


/** 
 Create a KRun object to run the preferred application for a file/URL.
 KRun will first determine the type of the file, and will then
 run the associated application.

*/
	private native void newKRun( KURL url, long mode, boolean isLocalFile, boolean showProgressInfo);
	public KRun( KURL url, long mode, boolean isLocalFile, boolean showProgressInfo) {
		super((Class) null);
		newKRun( url, mode, isLocalFile, showProgressInfo);
	}
	private native void newKRun( KURL url);
	public KRun( KURL url) {
		super((Class) null);
		newKRun( url);
	}

/** 
 Destructor. Don't call it yourself, since a KRun object auto-deletes
 itself.
   
*/
	protected native void finalize() throws InternalError;
	public native boolean hasError();
	public native boolean hasFinished();

/** 
 By default auto deletion is on.
   
*/
	public native boolean autoDelete();
	public native void setAutoDelete( boolean b);

/** 
 Open a list of URLs with a certain service.

*/
	public static native long run( KService _service, ArrayList _urls);

/** 
 Open a list of URLs with.

*/
	public static native long run( String _exec, ArrayList _urls, String _name, String _icon, String _mini_icon, String _desktop_file);
	public static native long run( String _exec, ArrayList _urls);

/** 
 Open the given URL.

 This function is used after the mime type
 is found out. It will search for all services which can handle
 the mime type and call {@link #run} afterwards.
   
*/
	public static native long runURL( KURL _url, String _mimetype);

/** 
 Run the given shell command and notifies kicker of the starting
 of the application. If the program to be called doesn't exist,
 an error box will be displayed.

 {@link _cmd} must be a shell command. You must not append "&"
 to it, since the function will do that for you.

 Use only when you know the full command line. Otherwise use the other
 static methods, or {@link KRun}'s constructor.
   
*/
	public static native long runCommand( String cmd);

/** 
 Same as the other runCommand, but it also takes the name of the
 binary, to display an error message in case it couldn't find it.

*/
	public static native long runCommand( String cmd, String execName, String icon);

/** 
 Quotes a string for the shell
   
*/
	public static native void shellQuote( String _str);
	protected native void init();
	protected native void scanFile();

/** 
 Called if the mimetype has been detected. The function checks
 whether the document and appends the gzip protocol to the
 URL. Otherwise {@link #runURL} is called to finish the job.
   
*/
	protected native void foundMimeType( String _type);
	protected native void killJob();
	protected native void slotTimeout();
	protected native void slotScanFinished( Job arg1);
	protected native void slotStatResult( Job arg1);

/** 
 For remote URLs to be opened with apps that don't support
 remote URLs. Uses kfmexec.
   
*/
	protected static native long runOldApplication( String _exec, ArrayList _urls, boolean _allow_multiple);

/** 
 Runs a shell command.

 {@link _cmd} must be a quoted shell command. You must not append "&"
 to it, since the function will do that for you. An example is
 "<tt>greet 'Hello Torben'</tt>".

*/
	protected static native long run( String _cmd);

/** 

 Use {@link KStartupInfo} instead.
   
*/
	protected static native void clientStarted( String name, String iconName, long pid, String resName, boolean compliant, int screen_number);
	protected static native void clientStarted( String name, String iconName, long pid, String resName, boolean compliant);

/** 
 Extracts binary name from Exec command line

*/
	protected static native String binaryName( String execLine, boolean removePath);
	protected static native long runCommandInternal( KProcess poc, String binName, String execName, String iconName);
}
