/***************************************************************************
                            KSpell.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 See {@link KSpellSignals} for signals emitted by KSpell.

 See {@link KSpellEventHandling} for event handlers to override in subclasses of KSpell.

*/
public class KSpell extends QObject  {
	protected KSpell(Class dummy){super((Class) null);}


/** 
 Start spellchecker.

 {@link KSpell} emits {@link #ready} when it has verified that 
 ISpell/ASpell is working properly. Pass the name of a slot -- do not pass zero!
 Be sure to call {@link #cleanUp} when you are done with {@link KSpell}.

 If {@link KSpell} could not be started correctly, {@link #death} is emitted.

*/
	private native void newKSpell( QWidget _parent, String _caption, QObject obj, String slot, KSpellConfig _kcs, boolean _progressbar, boolean _modal);
	public KSpell( QWidget _parent, String _caption, QObject obj, String slot, KSpellConfig _kcs, boolean _progressbar, boolean _modal) {
		super((Class) null);
		newKSpell( _parent, _caption, obj, slot, _kcs, _progressbar, _modal);
	}
	private native void newKSpell( QWidget _parent, String _caption, QObject obj, String slot);
	public KSpell( QWidget _parent, String _caption, QObject obj, String slot) {
		super((Class) null);
		newKSpell( _parent, _caption, obj, slot);
	}

/** 
 Retrieve the status of {@link KSpell}.

*/
	public native int status();

/** 
 Clean up ISpell.

 Write out the personal dictionary and close ISpell's
  stdin.  A {@link #death} signal will be emitted when the cleanup is
  complete, but this method will return immediately.

*/
	public native void cleanUp();

/**  
 Auto-delete the {@link KSpell} object after emitting {@link #death}.
   
*/
	public native void setAutoDelete( boolean _autoDelete);

/** 
  Spellcheck a buffer of many words in plain text 
  format.

 The <code>_buffer</code> is not modified.  The signal {@link #done} will be
  sent when {@link #check} is finished and the argument will be a 
  spell-corrected version of <code>_buffer.</code>  

 The spel check may be stopped by the user before the entire buffer
  has been checked.  You can check {@link #lastPosition} to see how far
  in <code>_buffer</code> {@link #check} reached before stopping.
   
*/
	public native boolean check( String _buffer);

/** 
 Retrieve the position (when using {@link #check})  or word 
 number (when using {@link #checkList}) of
 the last word checked.

*/
	public native int lastPosition();

/** 
 Spellcheck a list of words.

 {@link #checkList} is more flexible than {@link #check}.  You could parse
  any type
  of document (HTML, TeX, etc.) into a list of spell-checkable words
  and send the list to {@link #checkList}.  Sending a marked-up document
  to {@link #check} would result in the mark-up tags being
  spell checked.
   
*/
	public native boolean checkList( String[] _wordlist);

/** 
 Spellcheck a single word.

 checkWord() is the most flexible function.  Some applications
  might need this flexibility but will sacrifice speed when
  checking large numbers of words.  Consider {@link #checkList} for
  checking many words.

  Use this method for implementing  "online" spellchecking (i.e.,
  spellcheck as-you-type).

 checkWord () returns <code>false</code> if <code>buffer</code> is not a word, otherwise it
  returns <code>true</code>;

 If <code>usedialog</code> is set to <code>true</code>, {@link KSpell} will put up the standard
  dialog if the word is not found.  The dialog results can be queried
  by using  {@link #dlgResult} and {@link #replacement}. 

  The signal {@link #corrected} is emitted when the check is
  complete.  You can look at {@link #suggestions} to see what the
  suggested replacements were. 
   
*/
	public native boolean checkWord( String _buffer, boolean usedialog);
	public native boolean checkWord( String _buffer);

/** 
 Hide the dialog box.

 You'll need to do this when you are done with {@link #checkWord};
   
*/
	public native void hide();

/** 
 Retrieve list of suggested word replacements.

 After calling {@link #checkWord} (an in response to
  a {@link #misspelled} signal you can
  use this to get the list of
  suggestions (if any were available).
   
*/
	public native ArrayList suggestions();

/** 
 Get the result code of the dialog box.

 After calling checkWord, you can use this to get the dialog box's
  result code.
 The possible
  values are (from kspelldlg.h):

   
*/
	public native int dlgResult();

/** 
 Move the dialog.

 If the dialog is not currently visible, it will
   be placed at this position when it becomes visible.
 Use this to get the dialog out of the way of a highlighted
 misspelled word in a document.
   
*/
	public native void moveDlg( int x, int y);

/** 
 Retrieve the height of the dialog box.

*/
	public native int heightDlg();

/** 
 Retrieve the width of the dialog box.

*/
	public native int widthDlg();

/** 
 Retrieve the partially spellchecked buffer.

 You might want the full buffer in its partially-checked state.
   
*/
	public native String intermediateBuffer();

/** 
 Tell ISpell/ASpell to ignore this word for the life of this {@link KSpell} instance.

  {@link #ignore} returns <code>false</code> if word is not a word or there was an error
  communicating with ISpell/ASpell.
   
*/
	public native boolean ignore( String word);

/** 
 Add a word to the user's personal dictionary. 

 Returns <code>false</code> if <code>word</code>
  is not a word or there was an error communicating with ISpell/ASpell.
   
*/
	public native boolean addPersonal( String word);

/** 
 Retrieve the {@link KSpellConfig} object being used by this {@link KSpell} instance.
   
*/
	public native KSpellConfig ksConfig();

/** 
 Set the resolution (in percent) of the {@link #progress} signals.

 E.g. {@link #setProgressResolution} instructs {@link KSpell} to send progress
  signals (at most) every 10% (10%, 20%, 30%...).
 The default is 10%.
   
*/
	public native void setProgressResolution( int res);

/** 
 The destructor instructs ISpell/ASpell to write out the personal
  dictionary and then terminates ISpell/ASpell.
   
*/
	protected native void finalize() throws InternalError;
	public native void setIgnoreUpperWords( boolean _b);
	public native void setIgnoreTitleCase( boolean _b);

/** 
 Perform a sychronous spellcheck.

 This method does not return until spellchecking is done or canceled.
 Your application's GUI will still be updated, however.
   
*/
	public static native int modalCheck( String text);

/** 
 Used local spell config
   
*/
	public static native int modalCheck( String text, KSpellConfig _kcs);
	protected native int parseOneResponse( String _buffer, String word, String[] sugg);
	protected native String funnyWord( String word);
	protected native void dialog( String word, String[] sugg, String _slot);
	protected native String replacement();
	protected native void setUpDialog( boolean reallyusedialogbox);
	protected native void setUpDialog();
	protected native void emitProgress();
	protected native boolean cleanFputs( String s, boolean appendCR);
	protected native boolean cleanFputs( String s);
	protected native boolean cleanFputsWord( String s, boolean appendCR);
	protected native boolean cleanFputsWord( String s);
	protected native void startIspell();
	protected native boolean writePersonalDictionary();
	protected native void KSpell2( KProcIO arg1);
	protected native void checkWord2( KProcIO arg1);
	protected native void checkWord3();
	protected native void check2( KProcIO arg1);
	protected native void checkList2();
	protected native void checkList3a( KProcIO arg1);
	protected native void checkList3();
	protected native void checkList4();
	protected native void dialog2( int dlgresult);
	protected native void check3();
	protected native void slotStopCancel( int arg1);
	protected native void ispellExit( KProcess arg1);
	protected native void emitDeath();
	protected native void ispellErrors( KProcess arg1, String arg2, int arg3);
	public static final int Starting = 0;
	public static final int Running = 0;
	public static final int Cleaning = 1;
	public static final int Finished = 2;
	public static final int Error = 3;
	public static final int Crashed = 4;
}
