/***************************************************************************
                            KTextBrowser.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An extended {@link QTextBrowser}.

 By default it will
 invoke the system mailer or the system browser when a link is
 activated, or it can emit the signal {@link #urlClick} or {@link #mailClick}
 when a link is activated.

 See {@link KTextBrowserSignals} for signals emitted by KTextBrowser.

 See {@link KTextBrowserEventHandling} for event handlers to override in subclasses of KTextBrowser.

 @author Espen Sand (espensa@online.no)

 @version $Id: KTextBrowser.java,v 1.2.2.1 2001/08/29 23:14:11 rdale Exp $
 
 @short Extended QTextBrowser.

*/
public class KTextBrowser extends QTextBrowser  {
	protected KTextBrowser(Class dummy){super((Class) null);}


/** 
 Constructor.

*/
	private native void newKTextBrowser( QWidget parent, String name, boolean notifyClick);
	public KTextBrowser( QWidget parent, String name, boolean notifyClick) {
		super((Class) null);
		newKTextBrowser( parent, name, notifyClick);
	}
	private native void newKTextBrowser();
	public KTextBrowser() {
		super((Class) null);
		newKTextBrowser();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Decide whether a click on a link should be handled internally
 or if a signal should be emitted.

*/
	public native void setNotifyClick( boolean notifyClick);

/** 
 Returns whether a click on a link should be handled internally
 or if a signal should be emitted.
     
*/
	public native boolean isNotifyClick();

/** 
       Reimplemented to NOT set the source but to do the special handling.
       Do not call.
     
*/
	public native void setSource( String name);
}
