/***************************************************************************
                            KThemeCache.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A very simple pixmap cache for theme plugins. QPixmapCache is not used
 since it uses String keys which are not needed. All the information we
 need can be encoded in a numeric key. Using QIntCache instead allows us to
 skip the string operations.

 This class is mostly just inline methods that do bit operations on a key
 composed of the widget ID, width and/or height, and then calls
 QIntCache.find().

 One other thing to note is that full, horizontal, and vertically scaled
 pixmaps are not used interchangeably. For example, if you insert a fully
 scaled pixmap that is 32x32 then request a horizontally scaled pixmap with
 a width of 32, they will not match. This is because a pixmap that has been
 inserted into the cache has already been scaled at some point and it is
 very likely the vertical height was not originally 32. Thus the pixmap
 will be wrong when drawn, even though the horizontal width matches.

 
 See {@link KThemeCacheSignals} for signals emitted by KThemeCache.

 See {@link KThemeCacheEventHandling} for event handlers to override in subclasses of KThemeCache.

 @author Daniel M. Duley <mosfet@kde.org>

 @short 
 A very simple pixmap cache for theme plugins.
*/
public class KThemeCache extends QObject  {
	protected KThemeCache(Class dummy){super((Class) null);}


/** 
 The constructor.

*/
	private native void newKThemeCache( int maxSize, QObject parent, String name);
	public KThemeCache( int maxSize, QObject parent, String name) {
		super((Class) null);
		newKThemeCache( maxSize, parent, name);
	}
	private native void newKThemeCache( int maxSize);
	public KThemeCache( int maxSize) {
		super((Class) null);
		newKThemeCache( maxSize);
	}

/** 
 Inserts a new pixmap into the cache.

*/
	public native boolean insert( KThemePixmap pixmap, int scale, int widgetID, boolean border, boolean mask);
	public native boolean insert( KThemePixmap pixmap, int scale, int widgetID);

/** 
 Returns a fully scaled pixmap.

*/
	public native KThemePixmap pixmap( int w, int h, int widgetID, boolean border, boolean mask);
	public native KThemePixmap pixmap( int w, int h, int widgetID);

/** 
 Returns a horizontally scaled pixmap.

*/
	public native KThemePixmap horizontalPixmap( int w, int widgetID);

/** 
 Returns a vertically scaled pixmap.

*/
	public native KThemePixmap verticalPixmap( int h, int widgetID);
	protected native void flushTimeout();
	public static final int FullScale = 0;
	public static final int HorizontalScale = 1;
	public static final int VerticalScale = 2;
}
