/***************************************************************************
                            NodeFilter.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Filters are objects that know how to "filter out" nodes. If an
 Iterator or <code> TreeWalker </code> is given a filter, before it
 returns the next node, it applies the filter. If the filter says to
 accept the node, the Iterator returns it; otherwise, the Iterator
 looks for the next node and pretends that the node that was
 rejected was not there.

  The DOM does not provide any filters. Filter is just an interface
 that users can implement to provide their own filters.

  Filters do not need to know how to iterate, nor do they need to
 know anything about the data structure that is being iterated. This
 makes it very easy to write filters, since the only thing they have
 to know how to do is evaluate a single node. One filter may be used
 with a number of different kinds of Iterators, encouraging code
 reuse.

 To create your own cutsom NodeFilter, define a subclass of
 CustomNodeFilter which overrides the acceptNode() method and assign
 an instance of it to the NodeFilter. For more details see the
 CustomNodeFilter class
 
 @short 
 Filters are objects that know how to "filter out" nodes.
*/
public class  NodeFilter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected NodeFilter(Class dummy){}

	private native void newNodeFilter();
	public NodeFilter() {
		newNodeFilter();
	}
	private native void newNodeFilter( NodeFilter other);
	public NodeFilter( NodeFilter other) {
		newNodeFilter( other);
	}
	protected native void finalize() throws InternalError;

/** 
 Test whether a specified node is visible in the logical view of
 a TreeWalker or NodeIterator. This function will be called by
 the implementation of TreeWalker and NodeIterator; it is not
 intended to be called directly from user code.

     
*/
	public native short acceptNode( DOMNode n);

/** 

 not part of the DOM
     
*/
//	public native NodeFilterImpl handle();
	public native boolean isNull();
//	public native void setCustomNodeFilter( CustomNodeFilter custom);
//	public native CustomNodeFilter customNodeFilter();
//	public static native NodeFilter createCustom( CustomNodeFilter custom);
//	private native void newNodeFilter( NodeFilterImpl i);
//	public NodeFilter( NodeFilterImpl i) {
//		newNodeFilter( i);
//	}
	public static final int FILTER_ACCEPT = 1;
	public static final int FILTER_REJECT = 2;
	public static final int FILTER_SKIP = 3;
	public static final int SHOW_ALL = 0xFFFFFFFF;
	public static final int SHOW_ELEMENT = 0x00000001;
	public static final int SHOW_ATTRIBUTE = 0x00000002;
	public static final int SHOW_TEXT = 0x00000004;
	public static final int SHOW_CDATA_SECTION = 0x00000008;
	public static final int SHOW_ENTITY_REFERENCE = 0x00000010;
	public static final int SHOW_ENTITY = 0x00000020;
	public static final int SHOW_PROCESSING_INSTRUCTION = 0x00000040;
	public static final int SHOW_COMMENT = 0x00000080;
	public static final int SHOW_DOCUMENT = 0x00000100;
	public static final int SHOW_DOCUMENT_TYPE = 0x00000200;
	public static final int SHOW_DOCUMENT_FRAGMENT = 0x00000400;
	public static final int SHOW_NOTATION = 0x00000800;
}
