/***************************************************************************
                          spy.cpp  -  description
                             -------------------
    begin                : Tue May  1 02:59:33 BST 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistview.h>
#include <qsplitter.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qlabel.h>

#include "navview.h"
#include "propsview.h"
#include "sigslotview.h"
#include "spy.h"

extern "C"
 {
   void* init_libkspy()
   {
     qWarning( "KSpy: Initialising...\n" );
     Spy *s = new Spy();
     s->show();

     return 0;
   }
 };

Spy::Spy(QWidget *parent, const char *name) : QWidget(parent, name)
{
  QSplitter *div = new QSplitter( this );
  navView = new NavView( div );

  QTabWidget *tabs = new QTabWidget( div );

  propsView = new PropsView( tabs );
  tabs->addTab( propsView, "&Properties" );

  sigSlotView = new SigSlotView( tabs );
  tabs->addTab( sigSlotView, "&Signals/Slots" );

  tabs->addTab( new QLabel( "To be coded", tabs ), "&Class Info" );

  QHBoxLayout *box = new QHBoxLayout( this );
  box->addWidget( div );

  navView->buildTree();

  connect( navView, SIGNAL( selected( QObject * ) ),
	   propsView, SLOT( setTarget( QObject * ) ) );
  connect( navView, SIGNAL( selected( QObject * ) ),
	   sigSlotView, SLOT( setTarget( QObject * ) ) );
}

Spy::~Spy()
{
}


void Spy::setTarget( QWidget *t )
{
  target_ = t;
  propsView->buildList( t );
  sigSlotView->buildList( t );
}



#include "spy.moc"
