/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-2004  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */

#include "taglistview.h"

#include <qlayout.h>
#include <qwhatsthis.h>

#include <kcursor.h>
#include <klistbox.h>
#include <klocale.h>

#include "kbcatalog.h"

using namespace KBabel;

TagListView::TagListView(KBCatalog* catalog,QWidget *parent, Project::Ptr project)
    : KBCatalogView(catalog,parent,project)
{
    QVBoxLayout* layout = new QVBoxLayout( this );
    layout->setResizeMode( QLayout::Minimum );

    _tagBox = new KListBox (this, "taglist textview");
    
    layout->addWidget (_tagBox);
    
    connect(_tagBox,SIGNAL(selected(const QString&))
            , this, SIGNAL(signalTagSelected(const QString&)));
    connect(_tagBox,SIGNAL(highlighted(int))
            , this, SIGNAL(signalHighlightedTagChanged(int)));
	    
    connect(_catalog, SIGNAL(signalFileOpened(bool))
	    , this, SLOT(setDisabled(bool)));
}

void TagListView::updateView()
{
    _tagBox->clear();
    _tagBox->insertStringList(_catalog->tagList(_currentIndex));
    _tagBox->setCurrentItem(0);
}

void TagListView::highlightTag(int index)
{
    _tagBox->setCurrentItem(index);    
}

#include "taglistview.moc"
