/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DDATAITEM_H
#define _DDATAITEM_H

#include <qfont.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qvaluelist.h>

#include "DItem.h"

class QPixmap;
class QString;
class QColor;
class QTextStream;
class QFont;
class DDataControl;

/**
 * This class holds all data of a reference
 * 
 * @short reference data class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.6
 */
class DRef
{
    public:
	/// id
	int m_ref;

	/// caption
	QString m_text;
};

/**
 * URL handler
 */
struct URLObject
{
	QString m_url;
	QString m_caption;
};

/**
 * This class handles the data for the mindmap items 
 *
 * @short Mindmap item class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DDataItem : public DItem
{
    friend class DissertParser;
    friend class FFParser;
    
    public:
	DDataItem(DDataControl*, int);
	~DDataItem();

	/// add an item as a child of the current one
	void addChild( int id );

	/// set the parent of this item
	void setParent( int id );

	/// remove a child
	void removeChild( int id );



	/// number of children (not recursive)
	int countChildren() const;

	/// counts the amount of leaves in the subtree recursively
	int countFamily() const;
	

	/// id of the nth child
	int childNum(int) const;

	/// index of a child (using its id)
	int childIdx(int) const;

	/// tell a child to be nth in the family
	void setChildIdx( int id, int pos );


	/// id of the parent
	int Parent() const { return m_parent; }

	/// make an orphan ..
	void setNoParent();

	/// print the data
	void printSelf(QTextStream&);

	/// set the brush color
	void setColorScheme(int c);

	/// set a custom color for brush, outline and text
	void setCustomColors(QColor c1, QColor c2, QColor c3);

	/// set the position of items on canvas
	void setXY(int, int);

	/// color accessors
	QColor fillColor();
	QColor outlineColor();
	QColor textColor();

	/// real fill color for non-root items - root items have the root color
	QColor realFillColor();
	
	/*
	 * The font used for this item
         * It is set to Settings::canvasFont by default
         */
	QFont m_defaultFont;

	/// text held by the item
	QString m_text;
	/// summary : one line describing the concept
	QString m_summary;
	/// comment : text that does not appear anywhere
	QString m_comment;
	
	/// original picture, not resized
	QPixmap m_pix;

	/// thumbnail, set to Settings::pixSize()
	QPixmap m_pixtb;

	/// caption for the picture
	QString m_piccaption;
	QString m_picurl;

	/// name of the file held in the temporary directory
	QString m_picfilename;

	QValueList<URLObject> m_urllist;
	QValueList<int> m_flags;
	
	/// the message to display in the views if the summary is empty
	QString dispmsg();

	/// x position of the item on the canvas view
	int x() const { return m_x; }
	/// y position of the item on the canvas view
	int y() const { return m_y; }

	/// last child idx considered on the mindmap view
	int m_lastchild;

	/** load a picture from a file
	 * the file is automatically added to 
	 * the list of cached documents
	 */
	void loadPix(const QString & file);

	int colorScheme() const { return m_colorscheme; }
	
	void setChanged();

	void incrementFontSize(int);

	// META-DATA

	/* 
	 * references
	 */
	void addRef(int);
	void rmRef(int);
	bool isRef(int);
	DRef* ref_idx(int);
	int ref_count();
	
    private:
	QValueList<int> m_children;
	QValueList<DRef*> m_references;

	/// X position of the item on the mindmap view
	int m_x;
	/// Y position of the item on the mindmap view
	int m_y;

	/// colors - reuse the settings color as much as possible
	int m_colorscheme;
	
	// these are provided for the "custom" color section
	QColor m_fillcolor;
	QColor m_outlinecolor;
	QColor m_textcolor;

    protected:
	DDataControl *m_manager;

	/// parent item, set initially to NOITEM (no parent)
	int m_parent;

    public:
	static QString protectXML(const QString & str);
	static QString printXMLTag(const QString & tag, const QString & str, int padding = 0);

};

#endif // _DDATAITEM_H

