/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <klocale.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <kurl.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <kglobal.h>

#include "DDataItem.h"
#include "BoxURL.h"
#include "MiscProperties.h"

MiscProperties::MiscProperties(QWidget *parent, const char *name) : 
	MiscProperties_base(parent, name)
{
	m_lastitem = NULL;

	picselector->setFilter("image/png image/jpeg");

	linksbox->setColumnLayout(0, Qt::Vertical );
	linksbox->layout()->setSpacing( 6 );
	linksbox->layout()->setMargin( 11 );
	QGridLayout* layout = new QGridLayout( linksbox->layout() );
	layout->setAlignment( Qt::AlignTop );
	m_boxurl = new BoxURL( linksbox );
	layout->addWidget( m_boxurl, 0, 0 );

	dispInitialPixmap();

	connect(picselector, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(picsummary , SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	connect(commentedit, SIGNAL(textChanged()), this, SLOT(updateItem()) );

	setCurrentItem(NULL);
}

MiscProperties::~MiscProperties()
{
}

void MiscProperties::resizeEvent( QResizeEvent* )
{
	dispInitialPixmap();
}

void MiscProperties::dispInitialPixmap()
{
	QPixmap pix;
	if (m_lastitem && ! m_lastitem->m_pix.isNull())
	{
		QImage img = m_lastitem->m_pix.convertToImage();

		if (img.isNull()) kdWarning()<<"beware, img is null"<<endl;

		pix.convertFromImage( img.smoothScale( picpreview->width(), picpreview->height(), QImage::ScaleMin ) );
	}
	else
	{
		int size=picpreview->width();
		if (size > picpreview->height()) size = picpreview->height();
		pix = KGlobal::iconLoader()->loadIcon( "nopix", KIcon::NoGroup, size);
	}

	if (pix.isNull())
		return;

	QPixmap disp( picpreview->width(), picpreview->height() );
	disp.fill();

	int offx=0, offy=0;
	if (pix.height() < disp.height()) offy = (disp.height()-pix.height())/2;
	else if (pix.width() < disp.width()) offx = (disp.width()-pix.width())/2;

	copyBlt(&disp, offx, offy, &pix, 0, 0, pix.width(), pix.height());
	picpreview->setPixmap( disp );	
}

void MiscProperties::setCurrentItem(DDataItem* item)
{
	disconnect(picselector, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	disconnect(picsummary , SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	disconnect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	disconnect(commentedit, SIGNAL(textChanged()), this, SLOT(updateItem()) );

	m_boxurl->setCurrentItem(item);
	
	if (item)
	{
		groupBox1->setEnabled(true);
		groupBox4->setEnabled(true);
		linksbox->setEnabled(true);
		
		picselector->setEnabled(true);
		picsummary->setEnabled(true);
		m_boxurl->setEnabled(true);
		commentedit->setReadOnly(false);

		if (item != m_lastitem)
		{
			m_lastitem = item;

			dispInitialPixmap();

			picselector->setURL( m_lastitem->m_picurl );
			picsummary->setText( m_lastitem->m_piccaption );

			commentedit->setText( m_lastitem->m_comment );
		}
	}
	else
	{
		groupBox1->setEnabled(false);
		groupBox4->setEnabled(false);
		linksbox->setEnabled(false);
		
		picselector->setEnabled(false);
		picsummary->setEnabled(false);
		m_boxurl->setEnabled(false);
		commentedit->setReadOnly(true);

		if (item != m_lastitem)
		{
			m_lastitem = item;

			picselector->clear();
			picsummary->clear();
			commentedit->clear();

			dispInitialPixmap();
		}
	}

	connect(picselector, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(picsummary , SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	connect(commentedit, SIGNAL(textChanged()), this, SLOT(updateItem()) );
}

void MiscProperties::updateItem()
{
	if (!m_lastitem)
		return;

	disconnect(picselector, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	disconnect(picsummary , SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	disconnect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	disconnect(commentedit, SIGNAL(textChanged()), this, SLOT(updateItem()) );

	KURL url = picselector->url();
	if (url != m_lastitem->m_picurl)
	{
		//kdWarning()<<"loading pixmap"<<endl;
		QString urlname = url.url();
		m_lastitem->loadPix( urlname );
		m_lastitem->m_picurl = urlname;
		dispInitialPixmap();
	}

	m_lastitem->m_comment = commentedit->text();
	m_lastitem->m_piccaption = picsummary->text();

	m_lastitem->setChanged();

	connect(picselector, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(picsummary , SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()) );
	connect(m_boxurl, SIGNAL(datachanged()), this, SLOT(updateItem()) );
	connect(commentedit, SIGNAL(textChanged()), this, SLOT(updateItem()) );
}

#include "MiscProperties.moc"
