/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include <searchdlg_layout.h>
#include "kerryapp.h"
#include "beaglesearch.h"
#include "query.h"
#include <kio/previewjob.h>
#include <kfileitem.h>
#include <dcopinterface.h>
#include <kabc/addressbook.h>
#include <kabc/stdaddressbook.h>

class KFileItem;
class QCheckBox;
class KBookmarkManager;
class KBookmarkGroup;
class HitWidget;

class SearchDlg : public HitsLayout, virtual public dcopIface
{
    Q_OBJECT

	enum ScopeType {
		Everywhere,
		Applications,
		Contacts,
		Documents,
		Conversations,
		Images,
		Media,
		Website,
		FilePathName
	};

	enum SortType {
                Type,
		Modified,
		Name,
		Relevance
	};

	enum DateRange {
		AnyDate,
		Today,
		SinceYesterday,
		ThisWeek,
		ThisMonth,
		ThisYear
	};

  public:
    SearchDlg(QWidget *parent = 0, const char *name = 0);
    ~SearchDlg();

  public slots:
    void search(const QString& text);
    void search(const QString& text, const QString& scope);
    void showSearchDialog();
    void configChanged();

  protected:
    void setDisplayAmount(int);
    void setSortOrder(int);

    void keyPressEvent(QKeyEvent *);
    void showEvent(QShowEvent *);
    bool eventFilter(QObject *obj, QEvent *e); 

  signals:
    void configure();
    void readConfiguration();

  private slots:
    void slotStartBeagle();
    void slotButtonClear();
    void slotClear();
    void slotPrevious();
    void slotNext();
    void search();
    void searchChanged(const QString &);
    void searchHasOutput(BeagleSearch::BeagleResultList &results);
    void searchLostOutput(BeagleSearch::VanishedURIList &results);
    void searchFinished();
    void searchError (const QString& error);
    void sortFilterResults();
    void slotOpen();
    void slotOpenDir();
    void slotMailTo(const QString&);
    void slotOpenEvolution(const QString&);
    void slotOpenThunderbird(const QString&);
    void slotOpenKAddressBook(const QString&);
    void slotOpenKNotes(const QString&);
    void slotOpenURL(const QString&);
    void slotContextMenu( int row, int col, const QPoint & pos );
    void slotPreview(const KFileItem *, const QPixmap &);
    void slotPreviewResult();
    void slotCleanClientList ();
    void itemUncollapsed(HitWidget*);

  private:
    BeagleSearch* beagle_search;
    Query current_query;

    QPtrList<BeagleSearch> toclean_client_list;
    QMutex toclean_list_mutex;
    int current_beagle_client_id;

    BeagleSearch::BeagleResultList results, displayed_results;
    int displayOffset;
    int displayAmount;
    int defaultSortOrder,currentSortOrder;
    void insertResult(BeagleSearch::beagle_result_struct *result,int index);
    void fillTableHits();
    void updateStatus();
    void showQuickTips();
    QString formatBytes(QString& bytesStr) const;
    QCheckBox* cb_beagleStart;
    bool beagleJustStarted;

    void customEvent (QCustomEvent *e);
    bool pending_showQuickTips;
    void displayResults(BeagleSearch::BeagleResultList &items);
    bool mimeTypeMatch( const QString& mimeType, const QStringList& mimeList ) const;
    bool canPreview( KFileItem* item );
    void updatePreviewMimeTypes();
    QStringList* pPreviewMimeTypes;
    KIO::PreviewJob *pPreviewJob;
    void startPreview( const KFileItemList& items );
    void stopPreview();
    KFileItemList previewItems;

    QString takeProperty( const QString& property, QStringList& propertyList);
    QDateTime datetimeFromString( const QString& );

    QRegExp encodingRegexp;

    void searchProgramList(QString relPath);
    bool checkUriInResults(const QString& path) const;

    KBookmarkManager *bookmarkManager;
    KABC::AddressBook* m_addressBook;
    void searchAddressbook();
    void searchBookmarks(KBookmarkGroup);

    ScopeType showMode;
    DateRange dateRange;
    bool showBigTiles;

    bool ensureServiceRunning(const QString & name);
    bool still_searching;
};

#endif
