\ zmatrix.4th
\
\ Complex matrix words
\
\ Copyright (c) 2002--2003 Krishna Myneni, April 5, 2002
\ Provided under the GNU General Public License
\
\ Requires:
\	matrix.4th
\	complex.4th
\
\ Revisions:
\
\	2003-02-18  added matrix arithmetic  km


: zmatrix ( nrows ncols -- | allot space for complex matrix and initialize)
	create 2dup * 2* dfloats 2 cells + ?allot mat_size! ;

: zmat_addr ( i j a -- a2 | returns address of the i j element of a )
	>r 1- 2* dfloats swap 1- r@ @ * 2* dfloats + r> + 8 + ;

: zmat@ ( i j a -- z | returns the i j element of a )
	zmat_addr z@ ;

: zmat! ( z i j a -- | store z as the i j element of a )
	zmat_addr z! ; 

: zmat_zero ( a -- | zero all entries in complex matrix )
	dup mat_size@ * >r 1 1 rot zmat_addr r>
	0 do dup >r z=0 r> z! dfloat+ dfloat+ loop drop ; 

: zrow@ ( i a -- zrc | fetch row i of zmatrix a as an zrc )
	dup @ >r 1 swap zmat_addr r> dup
	0 do over z@ frot swap dfloat+ dfloat+ swap loop nip ;

: zcol@ ( j a -- zrc | fetch column j of zmatrix a )
	dup mat_size@ 2* dfloats 2>r 1 -rot zmat_addr 2r>
	swap dup >r
	0 do over z@ frot swap over + swap loop 2drop r> ;

: zrow! ( zrc i a -- | store zrc as row i of zmatrix a )
	dup @ dup >r swap zmat_addr r>
	0 do 2>r r@ z! 2r> 2 dfloats - loop 2drop ;	

: zcol! ( zrc j a -- | store zrc as column j of zmatrix a )
	rot drop dup mat_size@ 2* dfloats >r dup >r -rot zmat_addr r> r>
	swap
	0 do >r >r r@ z! r> r@ - r> loop 2drop ; 

: zrow_swap ( i j a -- | interchange rows i and j for zmatrix a )
	tuck 2dup 2>r 2over 2>r
	2>r zrow@ 2r> zrow@
	2r> zrow! 2r> zrow! ;

: zcol_swap ( i j a -- | interchange columns i and j for a )
	tuck 2dup 2>r 2over 2>r
	2>r zcol@ 2r> zcol@
	2r> zcol! 2r> zcol! ; 
	
: zmat. ( a -- | print out the complex matrix )
	dup mat_size@ 1+
	swap 1+
	1 do
	  dup
	  1 do
	    over j i rot zmat@ z. 9 emit 
	  loop
	  cr
	loop
	2drop
;


\ The following temporary variables should NOT be used by external words!

variable za_temp
zvariable ztemp

: zmat-copy ( a1 a2 -- | copy zmatrix a1 to a2)
	over mat_size@ * dfloats 2* 2 cells + cmove ;

: zmat-conjg ( a -- | conjugate the zmatrix)
	dup mat_size@ drop 1+ 1 ?do
	  dup mat_size@ nip 1+ 1 ?do
	    dup j i rot zmat_addr dup >r z@ conjg r> z!
	  loop
	loop
	drop ;

: zmat-negate ( a -- | a_ij = -a_ij )
	dup mat_size@ drop 1+ 1 ?do
	  dup mat_size@ nip 1+ 1 ?do
	    dup j i rot zmat_addr dup >r z@ znegate r> z!
	  loop
	loop
	drop ;

: f*zmat ( f a -- | multiply zmatrix with real constant f)
	dup mat_size@ drop 1+ 1 ?do
	  dup mat_size@ nip 1+ 1 ?do
	    dup j i rot zmat_addr >r 
	    za_temp ! fdup r@ z@ frot z*f r> z! za_temp a@
	  loop
	loop
	drop fdrop ;

: z*zmat ( z a -- | multiply zmatrix with complex constant z) 
	dup mat_size@ drop 1+ 1 ?do
	  dup mat_size@ nip 1+ 1 ?do
	    dup j i rot zmat_addr >r
	    za_temp ! zdup r@ z@ z* r> z! za_temp a@
	  loop
	loop
	drop zdrop ;

: zmat+ ( a1 a2 a3 -- | add zmatrices a1 and a2, result in a3)
	za_temp ! 2dup mat_size@ rot mat_size@ 
	d= not abort" zmat+ matrices of unequal size"
	dup mat_size@ za_temp a@ mat_size!  \ a1 a2
	dup mat_size@ drop 1+ 1 ?do	\ loop over rows
	  dup mat_size@ nip 1+ 1 ?do	\ loop over cols
	    2dup j i rot zmat@ ztemp z!
	    j i rot zmat@ ztemp z@
	    z+
	    j i za_temp a@ zmat!
	  loop
	loop
	2drop ;

variable  zdpa_temp1
variable  zdpa_temp2
fvariable zdpn_temp	\ this is really a 2variable

: zmat-dot-product ( n1 a1 n2 a2 -- z )
	\ compute dot product of row n1 of a1 with column n2 of a2
	\ size compatibility is not checked; this is up to the user.
	zdpa_temp2 ! swap zdpa_temp1 ! zdpn_temp 2!
	z=0
	zdpa_temp1 a@ mat_size@ nip 1+ 1 ?do  \ loop over columns of a1
	  zdpn_temp 2@ drop i zdpa_temp1 a@ zmat@
	  i zdpn_temp 2@ nip  zdpa_temp2 a@ zmat@
	  z* z+
	loop ;
	   

: zmat-mul ( a1 a2 a3 -- | a3 will have matrix multiplication of a1 a2)
	za_temp ! 
	2dup mat_size@ drop swap mat_size@ nip
	<> abort" zmat-mul  incompatible size arguments"
	2dup swap mat_size@ drop swap mat_size@ nip za_temp a@ mat_size!
	za_temp a@ mat_size@ drop 1+ 1 ?do    \ row loop
	  za_temp a@ mat_size@ nip 1+ 1 ?do   \ column loop
	    2dup j -rot i swap zmat-dot-product
	    j i za_temp a@ zmat!
	  loop
	loop
	2drop ;


: zmat-transpose ( a1 a2 -- | a2 will be the transpose of a1)
	za_temp ! dup mat_size@ swap za_temp a@ mat_size!
	dup mat_size@ drop 1+ 1 ?do
	   i over zrow@  i za_temp a@ zcol!
	loop drop ;
