/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "misc.h"

#include <kurl.h>
#include <kmdcodec.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include <qcolor.h>
#include <qpixmapcache.h>

#include <X11/Xlib.h>

namespace KFTPGrabberBase {

QPixmap loadPanelPixmap(const QString &name)
{
  return KGlobal::iconLoader()->loadIcon(name, KIcon::Panel, 0, true);
}

QIconSet loadToolbarIcon(const QString &name, int state)
{
  return KGlobal::iconLoader()->loadIconSet(name, KIcon::Toolbar,0,state);
}

QIconSet loadSmallIcon(const QString &name, int state)
{
  return KGlobal::iconLoader()->loadIconSet(name, KIcon::Small,0,state);
}

QPixmap loadToolbarPixmap(const QString &name)
{
  return KGlobal::iconLoader()->loadIcon(name, KIcon::Toolbar,0, true);
}

QPixmap loadSmallPixmap(const QString &name)
{
  return KGlobal::iconLoader()->loadIcon(name, KIcon::Small,0, true);
}

QPixmap createColorPixmap(QString color)
{
  QPixmap tmp(28, 12);
  tmp.fill(QColor(color));
  
  QPixmap pixmap(32, 16);
  pixmap.fill(QColor(0, 0, 0));
  
  copyBlt(&pixmap, 2, 2, &tmp, 0, 0, 28, 12);

  return pixmap;
}

QString getStoreDir(const QString &filename)
{
  return locateLocal("appdata", filename);
}

QPixmap createProgressPixmap(int progress, int current)
{
  if (progress > 100)
    progress = 100;
    
  if (current > 100)
    current = 100;
    
  QPixmap pixmap;
  QString key = QString("%1:%2").arg(progress).arg(current);
  
  if(!QPixmapCache::find(key, pixmap)) {
    QPixmap tmp(100, 16);
    tmp.fill(QColor(237, 237, 237));
    
    if (progress > 0) {
      QPixmap p_pix(progress, 16);
      p_pix.fill(QColor(0, 115, 255));
      
      QPixmap c_pix(current, 16);
      c_pix.fill(QColor(0, 88, 192));
      
      copyBlt(&tmp, 0, 0, &p_pix, 0, 0, progress, 16);
      copyBlt(&tmp, 0, 0, &c_pix, 0, 0, current, 16);
    }
    
    QPixmapCache::insert(key, tmp);
    return tmp;
  }
  
  return pixmap;
}

bool isModifierKeysPressed(unsigned int mask)
{
  Window root;
  Window child;
  int root_x, root_y, win_x, win_y;
  unsigned int keybstate;
  XQueryPointer(qt_xdisplay(), qt_xrootwin(), &root, &child, &root_x, &root_y, &win_x, &win_y, &keybstate);

  return keybstate & mask;
}

QString appendPath(const QString &path, const QString &what)
{
  if (path.right(1) == "/")
    return path + what;
  else
    return path + "/" + what;
}

QString path2Name(const QString &path)
{
  // Convert full path to filename
  return (path == "/") ? QString("/") : path.mid(path.findRev('/')+1);
}

QString path2Dir(const QString &path)
{
  // Convert full path to path
  return path.mid(0, path.findRev('/'));
}

QString genID()
{
  return kapp->randomString(5);
}

QString encodePassword(const QString& password)
{
  return KCodecs::base64Encode(password.ascii(), true).data();
}

QString decodePassword(const QString& password)
{
  return KCodecs::base64Decode(password.ascii()).data();
}

KConfig *config(const QString &section)
{
  KConfig *conf = kapp->config();
  conf->setGroup(section);
  
  return conf;
}

KURL remoteUrl(const QString &path, KURL url)
{
  if (path.isEmpty())
    return KURL();
    
  KURL tmp = url;
  tmp.setPath(path);
  
  return tmp;
}

} // end namespace

