/***************************************************************************
                          geomeasure.h  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GEOMEASURE_H
#define GEOMEASURE_H

#include <geoobjects.h>
#include <qpixmap.h>
#include <kstddirs.h>

/**This class is the base class for all objects dealing with measuring.
  *@author Marc Bartsch
  */

class GeoMeasure : public GeoObjects
{
	public:

		GeoMeasure();
		~GeoMeasure();

		virtual void		getObjectOverlay( QList <QRect> & list );

	  virtual void 		paint( QPainter *p );
	  virtual bool 		contains( QPoint *pt );

	  virtual void 		move();
		virtual void 		move( QPoint *pt );

		virtual void 		writeToFile( KSimpleConfig *config );
		virtual void 		readFromFile( KSimpleConfig *config );

	protected:

		QRect  textRect;
		QPoint anchorPoint;
		QString value;
		QPixmap pic;
		QRect  picRect;
};

#endif
