/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXCONTACT_H
#define KIAXCONTACT_H

#include <qstring.h>
#include <qsettings.h>
#include <qdatetime.h>

class KiaxContact{

public:
    KiaxContact(QString cname, QString cnumber, QString caccountId);
    
    ~KiaxContact();
    
    QString getId();
    QString getName();
    QString getNumber();
    QString getAccountId();
    void setId(QString nid);
    void setName(QString nname);
    void setNumber(QString nnumber);
    void setAccountId(QString aid);
    void setIconName(QString name);
    QString getIconName();
    void load(); // reload account using its id
    void load(QString lid); // load account with id = lid
    bool save();
    void remove();
public:
    static int nextContact;
        
protected:
    QString id;  // a unique id, so we can have users with same names
    QString number; // extension to dial
    QString name; // user alias
    QString accountId; // with which account we have to dial him
    QString iconName;// name of the icon file to represent the contact

private:
    QString nameKey;
    QString numberKey;
    QString accountIdKey;
    
    QSettings * getSettings();
    void setKeys(QSettings * settings);    
    
};

#endif
