/***************************************************************************
                                  login.cpp
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#include "login.h"
#include "taim.h"
#include "application.h"
#include "buddylistwindow.h"
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qprogressdialog.h> 
#include <kiconloader.h>
#include <kconfig.h>
#include <kwin.h>
 
/**
 * Initializes the ui.
 * @param parent the parent widget
 * @param name the name of this widget
 */
Login::Login(QWidget *parent, const char *name) : KDialog(parent,name),
    progress(NULL),
    lastLoginName(""),
    loggingOnError(false),
    logingIn(false),
    manualLogOff(false){
  setCaption("Kinkatta - Login");
  setIcon(SmallIcon("kinkatta"));
  i_aimSettings = setup::settings();
  initDialog();

  KConfig &config = *KGlobal::config();
  config.setGroup("Login Window Location");
  int x = config.readNumEntry("x", -1);
  int y = config.readNumEntry("y", -1);
  if( x != -1 && y != -1)
    setGeometry(x, y, 300, 200);
}

/**
 * Save position before exiting.
 */
Login::~Login(){
  QRect globalGeometry = KWin::info( winId() ).frameGeometry;
  KConfig &config = *KGlobal::config();
  config.setGroup("Login Window Location");
  config.writeEntry("x", globalGeometry.x() );
  config.writeEntry("y", globalGeometry.y() );
}

/**
 * Load settings (name and password and both checks) into the widgets.
 */
void Login::updateSettings(){
  disconnect(autoLogin, SIGNAL(toggled(bool)), this, SLOT(toggleAuto(bool)));
  disconnect(save, SIGNAL(toggled(bool)), this, SLOT(toggleSave(bool)));
  save->setChecked(i_aimSettings->login_enable_save);
  aolPass->setText(i_aimSettings->login_password);
  aolName->insertItem(i_aimSettings->login_name, 0);
  autoLogin->setChecked(i_aimSettings->login_enable_auto);

  QString currentText = aolName->currentText();
  aolName->clear(); 
  aolName->insertStringList( setup::instance()->registeredUsers() );

  for (int i = aolName->count(); i > 0; i--){
    if (tocNormalize(aolName->text(i-1)) == tocNormalize(i_aimSettings->login_name)){
      aolName->setCurrentItem(i-1);
    }
    if (tocNormalize(aolName->text(i-1)) == tocNormalize(currentText))
      currentText = "";
  }
  if( currentText.length() > 0 ){
    aolName->insertItem(currentText);
    aolName->setCurrentItem(aolName->count()-1);
  }
  if (aolName->count() == 0)
    aolName->insertItem("<new user>");

  if (loggingOnError == false)
    if (i_aimSettings->login_enable_auto == true)
      signOnButtonClicked();
  connect(autoLogin, SIGNAL(toggled(bool)), this, SLOT(toggleAuto(bool)));
  connect(save, SIGNAL(toggled(bool)), this, SLOT(toggleSave(bool)));
}

/**
 * We are connected, set up the main window to be displayed and hide the
 * login window.  If we are re-logging in with another user, close the
 * old users windows.
 */
void Login::connected(){
  BuddyListWindow *mainWindow = (BuddyListWindow *)qApp->mainWidget();
  // If this a re-signon with a different user, close the previous users
  // chatwindows.	If this is a re-signon with the same user, leave existing
  // chatwindows open.
  if( lastLoginName != setup::settings()->login_name ){
    mainWindow->closeExistingChatwindows();
  }
  lastLoginName = setup::settings()->login_name;

  if (connection->getStatus() == TAIM_OFFLINE)
    return;

  this->hide();
  mainWindow->show();
  mainWindow->loggedIn();
}

/**
 * Close event occured, quit the application.
 */
void Login::closeEvent(class QCloseEvent *){
  qApp->quit();
}

/**
 * Tells this widget what is the network object.  Then makes connections to it.
 * @param network - the network obejct.
 */
void Login::setNetworkObject( TAim *network ){
  connection = network;
  connect(connection, SIGNAL(statusChanged(int)), this, SLOT(watchConnection(int)));
  connect(connection, SIGNAL(displayError(QString)), this, SLOT( displayNetworkError(QString)));
  connect(connection, SIGNAL(nick(QString)), this, SLOT(setNick(QString)));
  connect( connection, SIGNAL(initProgress(int, int, QString)), this, SLOT(initProgressBar(int, int, QString)) );
  connect( connection, SIGNAL(updateProgress(int, QString)), this, SLOT(updateProgressBar(int, QString)) );
  connect( connection, SIGNAL(endProgress()), this, SLOT(endProgressBar()) );
}

/**
 * If AutoSave is unchecked then the current password is deleted
 * @param value current state of save check
 */
void Login::toggleSave( bool value ){
  if (value == false){
    removePassword(aolName->currentText());
  }
} 

/**
 * If AutoLogin is checked the other one is automaticly checked and disabled
 * @param value current state of auto-login toggle
 */
void Login::toggleAuto( bool value ){
  if (value == true){
    save->setEnabled(false);
    save->setChecked(true);
  }
  else{
    save->setEnabled(true);	
  }
} 

/**
 * Moves the Cursor to the Password field if return is hit
 */
void Login::moveFocusToPass( int ){
  aolPass->setFocus();
}

/**
 * Saves the password to the settings data.
 * @param user specifies which user's password should be saved
 */
void Login::savePassword(QString name){
  QString plainPass = aolPass->text();
  setup::instance()->savePassword(name, plainPass);
}

/**
 * Retreives the user's password from the settings data.  If no
 * password was found, the dialog is not changed.
 * @param user specifies which user's password should be retreived
 */
void Login::readPassword( const QString &name ){
  QString password = setup::instance()->readPassword(name);
	
  aolPass->setText(password);
  if ( password.isEmpty() ){
    autoLogin->setChecked(false);
    save->setChecked(false);
  } else {
    save->setChecked(true);
  }
}

/**
 * Removes a user's password from the settings data.
 * @param user specifies which user's password should be cleared
 */
void Login::removePassword( QString name ){
  setup::instance()->removePassword(name);
}

/**
 * Attempts to Sign on
 * Occurs when the signOn button is clicked.
 */
void Login::signOnButtonClicked(){
  if(aolName->currentText() == QString("<new user>")){
    int choice = -1;
    choice = QMessageBox::information(0, "Kinkatta - Error",(
"Kinkatta can't register new aim users at this time.\nYou must goto aol's website and register for\na new account. (http://aim.aol.com)"), "Ok", "Goto web site to register.");
    if (choice == 1)
      kApp->invokeBrowser(QString( "http://aim.aol.com/ "));
    return;
  }
  if ((aolName->currentText().length() == 0 ) || (aolPass->text().length() == 0) ){
    QMessageBox::information(this, "Kinkatta - Message",("Please enter a name and password."), QMessageBox::Ok);
    return;
  }
  
  i_aimSettings->login_password = aolPass->text();
  i_aimSettings->login_name = aolName->currentText();
  i_aimSettings->login_enable_save = save->isChecked();
  i_aimSettings->login_enable_auto = autoLogin->isChecked();
  if (i_aimSettings->login_enable_save == true)
    savePassword(i_aimSettings->login_name);
  else
    removePassword(aolName->currentText());
  tryToConnect();
}

/**
 * Catches when the network goes online and offline and acts on them.
 * @Param status the new status of the network.
 */
void Login::watchConnection(int status){
  if ( status == TAIM_OFFLINE){
    if (logingIn == false)
    disconected();
  }
  else{
    if (logingIn == false){
      connected();
    }
  }
}

/**
 * Set the proper nick's spacing etc for the current online user.
 * @param name the proper name of the user.
 */
void Login::setNick( QString name ){
  i_aimSettings->login_name = name;
}

/**
 * Network code had an error, display it.
 * @param error the sting explaining the error.
 */
void Login::displayNetworkError( QString error ){
  loggingOnError = true;
  if (manualLogOff == true){
    if (error != "Disconnected.")
      QMessageBox::critical(this, "Kinkatta - Error",error, "Ok");
    manualLogOff = false;
  }
  else
    QMessageBox::critical(this, "Kinkatta - Error",error, "Ok");
}

/**
 * Save settings and emit a signal to open options.
 * Occurs when the Setup Button is hit.
 */
void Login::setupButtonClicked(){
  QString selected = aolName->currentText();
	
  i_aimSettings->login_enable_save = save->isChecked();
  i_aimSettings->login_enable_auto = autoLogin->isChecked();
	
  if( setup::instance()->isRegisteredUser(selected) ){
    i_aimSettings->login_name = selected;
  } else {
    i_aimSettings->login_name = "";
  }
  emit (showOptions());
} 

/**
 * The name or password has changed.  Check to see if either are of length 0
 * if either are then disable the signon button.
 */
void Login::enableDisableSignOnButton( const QString & ){
  if (aolName->currentText().length() == 0 || aolPass->text().length() == 0)
    signOn->setDisabled(true);
  else
    signOn->setDisabled(false);
}

/**
 * Create the widgets that make up the login window.  Connect the widgets to
 * the proper functions.
 */
void Login::initDialog(){
  Layout1 = new QVBoxLayout( this ); 
  Layout1->setSpacing( 6 );
  Layout1->setMargin( 11 );

  logoImage = new QLabel( this, "TextLabel1" );
  logoImage->setText( tr( " " ) );
  logoImage->setFixedSize(285,93);
  logoImage->setPixmap(SmallIcon("kinkattalogo"));
  Layout1->addWidget( logoImage );

  Layout2 = new QHBoxLayout; 
  Layout2->setSpacing( 6 );
  Layout2->setMargin( 0 );

  aolnameLabel = new QLabel( this, "aolnameL" );
  aolnameLabel->setText( tr( "                           Name" ) );
  Layout2->addWidget( aolnameLabel );

  aolName = new QComboBox( true , this, "aolName" );
  Layout2->addWidget( aolName );
  Layout1->addLayout( Layout2 );

  Layout3 = new QHBoxLayout; 
  Layout3->setSpacing( 6 );
  Layout3->setMargin( 0 );

  aolpassLabel = new QLabel( this, "aolpassL" );
  aolpassLabel->setText( tr( "Password" ) );
  Layout3->addWidget( aolpassLabel );

  aolPass = new QLineEdit( this, "aolPass" );
  aolPass->setEchoMode(QLineEdit::Password);
  Layout3->addWidget( aolPass );
  Layout1->addLayout( Layout3 );

  Layout4 = new QHBoxLayout; 
  Layout4->setSpacing( 6 );
  Layout4->setMargin( 0 );

  save = new QCheckBox( this, "save" );
  save->setText( tr( "Save Password" ) );
  Layout4->addWidget( save );

  autoLogin = new QCheckBox( this, "autoLogin" );
  autoLogin->setText( tr( "Auto Login" ) );
  autoLogin->setChecked( false );
  Layout4->addWidget( autoLogin );
  Layout1->addLayout( Layout4 );

  Layout5 = new QHBoxLayout; 
  Layout5->setSpacing( 6 );
  Layout5->setMargin( 0 );

  version = new QLabel( this, "verions" );
  version->setText( tr( "Ver 0.00" ) );
  // Set version number
  version->setText(release_number);
  QToolTip::add(version,release_date);

   Layout5->addWidget( version );

  pluginsButton = new QPushButton( this, "pluginsButton" );
  pluginsButton->setText( tr( "Plugins" ) );
  Layout5->addWidget( pluginsButton );

  setupButton = new QPushButton( this, "setup" );
  setupButton->setText( tr( "Options" ) );
  Layout5->addWidget( setupButton );

  signOn = new QPushButton( this, "signOn" );
  signOn->setText( tr( "Sign On" ) );
  signOn->setDisabled(true);
  Layout5->addWidget( signOn );
  Layout1->addLayout( Layout5 );

  // Connect the GUI to the appropiate slots
  connect(autoLogin, SIGNAL(toggled(bool)), this, SLOT(toggleAuto(bool)));
  connect(save, SIGNAL(toggled(bool)), this, SLOT(toggleSave(bool)));
  connect(aolName, SIGNAL(activated(int) ), this, SLOT(moveFocusToPass(int)));	
  connect(aolName, SIGNAL(textChanged( const QString &)), this, SLOT(readPassword(const QString&)));
	
  connect(aolPass, SIGNAL(textChanged( const QString &)), this, SLOT(enableDisableSignOnButton(const QString&)));
  connect(aolName, SIGNAL(textChanged( const QString &)), this, SLOT(enableDisableSignOnButton(const QString&)));

  connect(pluginsButton, SIGNAL(clicked()), this, SIGNAL(showPlugins()));
  connect(aolPass, SIGNAL(returnPressed()), this, SLOT(signOnButtonClicked()));	
  connect(signOn, SIGNAL(clicked()), this, SLOT(signOnButtonClicked()));
  connect(setupButton, SIGNAL(clicked()), this, SLOT(setupButtonClicked()));
}

/**
 * The network has been disconnected, hide the buddy list and bring up
 * the login screen (this).  
 */
void Login::disconected(){
  if (connection->getStatus() != TAIM_OFFLINE)
    return;

  BuddyListWindow *buddyWindow = (BuddyListWindow *)qApp->mainWidget();
  if(buddyWindow->awayRightNow == true)
     buddyWindow->away_BackForReal();
  buddyWindow->clearPostConnections();
  buddyWindow->hide();
  
  updateSettings();
  show();
}

/**
 * Manually log off.  Go offline and bring up login window.  Save settings.
 * Give the network all of the network settings and tell it to connect.
 */
void Login::logOff(){
  manualLogOff = true;
  connection->setStatus(TAIM_OFFLINE);
  disconected();
  BuddyListWindow *buddyWindow = (BuddyListWindow *)qApp->mainWidget();
  buddyWindow->saveAimSettings();
}

/**
 * Attempt to connect to aol with the current settings, username and password.
 */
void Login::tryToConnect(){
  if (connection->getStatus() != TAIM_OFFLINE)
    return;
  
  logingIn = true;
  loggingOnError = false;

  //save the options again, in case Options was pressed under a different user
  setup::instance()->readProfile( setup::settings()->login_name );

  TBuddyList buddy;
  TBuddyList permit;
  TBuddyList deny;
  int permitStatus;
  setup::instance()->parseBuddyList(setup::settings()->login_name,
  &buddy, &permit, &deny, &permitStatus);

  connection->setBuddyList(buddy);
  connection->setPermitList(permit);
  connection->setDenyList(deny);
  connection->setPermissions(permitStatus);

  // dokeepAlive
  connection->doKeepAlive(true);
  // Idle
  connection->doIdleTime(true);
  // SetCustom server
  connection->useCustomServer(true);
  connection->setCustomServer(setup::settings()->login_server_toc,
   setup::settings()->login_port_toc.toInt(),
   setup::settings()->login_server_login,
   setup::settings()->login_port_login.toInt());

	/*
	// Enable proxy
	if (setup::settings()->proxy_Choice == 2){
		connection->useSocksServer(true);
		connection->setSocksProxy(setup::settings()->proxy_server,atoi(setup::settings()->proxy_port.latin1()));
	}
	*/

  // Set UserName
  connection->setUserName( setup::settings()->login_name );
  // set Pass
  connection->setPassword( setup::settings()->login_password );
  // Set UserInfo
  connection->setUserInfo( setup::instance()->readProfile(i_aimSettings->login_name) );
  // setStatus(taim_online)
  connection->setStatus(TAIM_ONLINE);
}

/**
 * Creates a progress bar if there currently isn't one.  Set up values.
 * @param max - The max number of steps for the progressbar.
 * @param cur - The current step in the progressbar.
 * @param msg - The current message for the progressbar.
 */
void Login::initProgressBar(int max, int cur, QString msg){
  if(progress)
    delete progress;
  progress = new QProgressDialog(this, "Kinkatta - Login");
  progress->setCaption("Kinkatta - Signon");
  progress->setIcon(SmallIcon("kinkatta"));
  progress->setTotalSteps(max);
  connect( progress, SIGNAL(cancelled()), connection, SLOT(cancelProgress()) );
  progress->setProgress(cur);
  progress->setLabelText(msg);
  progress->show();
}

/**
 * Change the step and message in the login progressbar.
 * @param cur - The new step in the progressbar.
 * @param msg - The new message for the progressbar.
 */
void Login::updateProgressBar(int cur, QString msg) {
  if(!progress)
    return;
  progress->setProgress(cur);
  progress->setLabelText(msg);
}

/**
 * Delete the progressbar and call connected()
 */
void Login::endProgressBar() {
  if(!progress) return;
    delete progress;
  progress = NULL;
  logingIn = false;
  if (connection->getStatus() != TAIM_OFFLINE){
    connected();
  }
}

// login.cpp

