/***************************************************************************
                                  login.h
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef LOGIN_H
#define LOGIN_H

#include <kdialog.h>

#include "setup.h"

class TAim;
class QPushButton;
class QCheckBox;
class QLineEdit;
class QLabel;
class QComboBox;
class QHBoxLayout;
class QVBoxLayout;
class QProgressDialog;

/**
 * The login dialog for Kinkatta handles the network connection.  When not
 * connected this dialog will come up.  It has a QProgressDialog that will
 * attempt to connect and if successfull the main window will be show while
 * this is hidden, wating for a disconnect to occur.  The dialog itself is
 * simple and asks for name and passwords.  The user can bring up options
 * and plugins from this dialog.
 * @author Benjamin Meyer
 */
class Login : public KDialog {

Q_OBJECT

signals:
  /// Emitted when the plugins button is clicked.
  void showPlugins();

  /// Emitted when the options button is clicked.
  void showOptions();

public:
  /// Constructor.
  Login( QWidget *parent=0, const char *name=0 );

  /// Deconstructor.
  ~Login();

public slots:
  /// Update the onscreen items.
  void updateSettings();

  /// Sets the local network object.
  void setNetworkObject( TAim *network = NULL );
  
  /// Manually disconnect from aol.
  void logOff();

  /// Attempt to connect with the current username and password.
  void tryToConnect();

private slots:
  /// tryToConnect() was successfull, hide window, show main buddylist
  void connected();

  /// We have been disconnected. show window, hide main buddylist.
  void disconected();

  /// Catch status signals from the network connection.
  void watchConnection( int status );

  /// Display a network error
  void displayNetworkError( QString error );

  /// Set the proper aol name that the user signed on with.
  void setNick( QString name );
 
  /// Called when the signon button is clicked.
  void signOnButtonClicked();

  /// Move the focus to the password box.
  void moveFocusToPass( int );
  
  /// If we have a password enable the signon button.
  void enableDisableSignOnButton( const QString & );
  
  /// Save network settings before opening setup box.
  void setupButtonClicked();
  
  /// If true enable save
  void toggleAuto( bool value );
  
  /// If value is false delete current password.
  void toggleSave( bool value );

  /// Retreives a user's password.
  void readPassword( const QString &user );  
	
  /// Initialize the progress bar
  void initProgressBar( int, int, QString );

  /// Update the progress bar
  void updateProgressBar( int, QString );

  /// Remove the progress bar
  void endProgressBar();

private:
  /// Network connection.
  TAim *connection;

  /// Settings data
  settings_t *i_aimSettings;
  
  /// Saves the password for user into the settings.
  void savePassword( QString user );
  
  /// Removes a user's password
  void removePassword( QString user );

  /// Handle a close event
  void closeEvent(class QCloseEvent *);
 
  /// Creates the gui
  void initDialog();

  /// Progress dialog when logging on.
  QProgressDialog *progress;

  /// Keeps track of the last person to login so if you login as a new person it will close any old open im windows.
  QString lastLoginName;
  /// Only auto login if we didn't get a error on the last login (false).
  bool loggingOnError;
  /// True when logging in so we don't login while logging in.
  bool logingIn;
  /// If we are manually logging off don't show log off error.
  bool manualLogOff;

  QLabel *version;
  QLabel *logoImage;
  QLabel *aolnameLabel;
  QLabel *aolpassLabel;
  QComboBox *aolName;
  QLineEdit *aolPass;
  QCheckBox *save;
  QCheckBox *autoLogin;
  QPushButton *setupButton;
  QPushButton *signOn;
  QPushButton *pluginsButton;
  QHBoxLayout* Layout5;
  QHBoxLayout* Layout2;
  QHBoxLayout* Layout3;
  QHBoxLayout* Layout4;
  QVBoxLayout* Layout1;

};

#endif

// login.h

