/***************************************************************************
                                   chat.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ***************************************************************************/

#ifndef CHAT_H
#define CHAT_H

class ChatPlugin;

#include <kmainwindow.h>
#include <qlist.h>
#include <qfile.h>
#include <qtextstream.h>
class QFile;
class QTextStream;
class QMultiLineEdit;
class QSplitter;
class KinkattaTextBrowser;
class QLabel;
class QTextStream;
class QFile;
class QColor;
class KToggleAction;	
class KAction;

/**
 * This is the base class for a chat window.  It supports all of the normal
 * chat functionality while supporting expandability. Included is:
 * -Full Logging ability.
 * -SaveAs.
 * -Print capability.
 * -Basic Text editing.
 * -Background and pen color manipulation.
 * -Clear.
 * -Timestamp information.
 * -Smilies
 * -Last message
 * -An array of options for the above features.
 * @author Benjamin Meyer
 */

class Chat : public KMainWindow  {

Q_OBJECT

signals:
  /// Open this url. ( user clicked on it ).
  void openURL( const QString &url );
  /// Make the system go beep!
  void soundBeep();
  /// Play this file please!
  void soundPlayFile( const QString &file );

  /// A message to contact needs to be sent.
  void messageOut( QString contact, QString Message );
  /// This window wants to quit, someone needs to take care of it.
  void quiting( QString name );

public:
  Chat( QString userName, QString contactsName, QWidget *parent=0, QString alias=0 );
  ~Chat();
  KToolBar *getPluginToolbar() ;
  QString getContactName() const;
	
public slots:
  void contactSignedOff();
  void contactSignedOn();
  void sendOutAMessage( QString message );
  void postMessage( QString message );
  void messageIn( QString message );
  void insertChatPlugin( const ChatPlugin *plugin );
  void removeChatPlugin( const ChatPlugin *plugin );
  void removeAllPlugins();

  void updateChatColorSettings();
  void updateChatFontSettings();
  void updateChatSettings();
  void updateChatSoundSettings();

protected:
  // The init function for the widget
  virtual void initChatWindow();
	
  /// Name of the user using this window
  QString myName;
  /// Name of the contact we are talking too
  QString contactName;
  /// Alias for the contact
  QString contactAlias;

  /// The splitter between the input window and the log
  QSplitter *splitter;

  /// The text minipulation plugins. 
  QList<ChatPlugin> plugins;

private slots:
  /// Sub classes must implement to edit the toolbars.
  virtual void options_configuretoolbars() = 0;

  void keyPressEvent( QKeyEvent *e );
  void keyReleaseEvent( QKeyEvent *e );
  void resizeEvent( QResizeEvent *e );

  void flashIcon();
  void enterKeyPressed();
  void applytoInputWindow();
  void applytoChatWindow();
  void inputTextChanged();
  void copyChanged( bool changed );

  void mailToClicked( const QString &url, const QString &address );
	
  void slotChatLog();
  void slotChatClear();
  void slotChatSaveAs();
  void slotChatPrint();
  void slotChatSound();
  void slotChatClose();
  void closeEvent( QCloseEvent *e );

  void slotEditCut();
  void slotEditCopy();
  void slotEditPaste();
  void slotEditSelectAll();
  void slotEditUndo();
  void slotEditRedo();

  void slotViewChatToolBar();
  void slotViewTextToolBar();
  void slotViewPluginToolBar();
  void slotViewTimeStamp();

  void slotInsertFace( int face );
  void slotInsertTags( QString open, QString close );
  void slotInsertBold();
  void slotInsertItalic();
  void slotInsertUnderline();
  void slotInsertShrinkFont();
  void slotInsertNormalFont();
  void slotInsertIncreaseFont();
  void slotInsertBackGroundColor();
  void slotInsertPenColor();
  void slotInsertLink();
  void slotInsertLastMessage();
  
  void slotContactSendMessage();

private:
  /// If we were to send right *now* this is what we would send.
  QString currentMessageOut;
  /// If the window was just cleared.
  bool cleared;
  /// If we can copy from the widgets.
  bool canCopy;
  /// Current selected Font size
  int fontSize;
  /// Default normal font size for when the user selects normal.
  int normalFontSize;
		
  QColor temp_ContactBgColor;
  QColor temp_ContactTextColor;
  bool default_yourFont;
  bool default_contactFont;
  
  /// If shift is currently down.
  bool shiftIsPressed;
  /// The last message sent.
  QString lastMessage;

  /// The Log's file 
  QFile logFile;
  /// If there is a log, this is the stream
  QTextStream logStream;

  /// Log buffer without time.
  QString conversationBuffer;
  /// Log buffer with time.
  QString conversationTimeBuffer;
		
  /// Used to get around the 0/1 issue on chatWindow input
  int postNumber;

  /// If we should be flashing or not. 
  bool flashWindow;
  /// Which icon we are currently on if flashing.
  bool flashChoice;
  
  /// The log window.
  KinkattaTextBrowser *chatWindow;
  /// The input window.
  QMultiLineEdit *inputWindow;

  /// Open a log.
  void openLogFile();
  /// Close the log.
  void closeLogFile( const bool remove );

  void updateHTML(QString message, QString sender, QString HTMLColor);
  
  void autoLinkUrls( QString &text );
  /// Format the text to work with the display widget.
  void formatHtmlForDisplay( QString &text );
  /// Check over and clean up any html issues.
  void checkOverHtml( QString &text );
  /// Create a font tag from the parameters given.
  QString createFontTag( const QString face, const QString color, const int size );
  /// Remove all tags in the text.
  void removeAllTags( QString &text );
  /// Fix any smilies so that aol can render them.
  void fontFixSmilies( QString &message, QString fontTag );
  /// Replace smilies :) with the corresponding images.
  void replaceSmiliesWithImgTags( QString &message );


  KToggleAction *viewTextToolBar;
  KToggleAction *viewChatToolBar;
  KToggleAction *viewPluginToolBar;
  KToggleAction *time;
  KToggleAction *log;
  KToggleAction *sound;

  KAction *bold;
  KAction *italic;
  KAction *undo;
  KAction *redo;

  /// Options:

  /// Raises the window on a new message
  bool chat_raise_window;        
  /// Flashes the window on a new message
  bool chat_flash_on_new_message; 
  /// Log the chat
  bool chat_log;  
  /// Log the chat in html (or plain text)               
  bool chat_log_inHtml;           
  /// Show the time in the window
  bool chat_show_time;           
  /// Log the time 
  bool chat_log_time;
  /// Return sends a message             
  bool chat_return_send;
  /// Shift return sends a message
  bool chat_sreturn_send;         
  /// You can send blank messages
  bool chat_send_blank;          
  /// Strip out all html on new messages 
  bool chat_ignore_contacthtml;   
  /// Set a line limit for incoming messages
  bool chat_line_limit;           
  /// Show smilies as graphics
  bool chat_show_smilies;     
  /// The limit for chat_line_limit to start removing old messages
  int chat_line_limit_number;     
  /// Log to a single file.
  bool chat_log_singleFile;

  /// The font to use for outgoing
  QFont chat_yourFont;
  /// The font to use for incoming
  QFont chat_contactFont;

  /// Color for outgoing text
  QColor chat_yourText_color;
  /// Color for outgoing text Author
  QColor chat_yourName_color;
  /// Color for incoming text
  QColor chat_contactText_color;
  /// Color for incoming text Author
  QColor chat_contactName_color;
  /// Color for outgoing background
  QColor chat_yourbg_color;
  /// Color for incoming background
  QColor chat_contactbg_color;

  /// If we are using sound
  bool chat_sound;
  /// Beep on initial
  bool chat_sound_beepInitial;
  /// Beep on incoming.
  bool chat_sound_beepReceive;
  /// Beep when sending.
  bool chat_sound_beepSend;
  /// Play files?
  bool chat_sound_playFile;
  /// Play file on send.
  QString chat_sound_fileSend;
  /// Play file on receive
  QString chat_sound_fileReceive;
  /// Play file on initial.
  QString chat_sound_fileInitial;

};

#endif

// chat.h

