/***************************************************************************
                                   smilies.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ***************************************************************************/
#ifndef SMILIES_H
#define SMILIES_H

#define FACE_SMILE_ID 1
#define FACE_SMILE_TEXT ":-)"
#define FACE_SAD_ID 2
#define FACE_SAD_TEXT ":-("
#define FACE_WINK_ID 3
#define FACE_WINK_TEXT ";-)"
#define FACE_TONGUE_ID 4
#define FACE_TONGUE_TEXT ":-P"
#define FACE_SCREAM_ID 5
#define FACE_SCREAM_TEXT "=-O"
#define FACE_KISS_ID 6
#define FACE_KISS_TEXT ":-*"
#define FACE_YELL_ID 7
#define FACE_YELL_TEXT ">:o"
#define FACE_GLASSES_ID 8
#define FACE_GLASSES_TEXT "8-)"
#define FACE_ONEEYE_ID 17
#define FACE_ONEEYE_TEXT "O-)"
#define FACE_MONEYMOUTH_ID 9
#define FACE_MONEYMOUTH_TEXT ":-$"
#define FACE_BURP_ID 10
#define FACE_BURP_TEXT ":-!"
#define FACE_EMBARRASSED_ID 11
#define FACE_EMBARRASSED_TEXT ":-["
#define FACE_ANGEL_ID 12
#define FACE_ANGEL_TEXT "O:-)"
#define FACE_THINK_ID 13
#define FACE_THINK_TEXT ":-\\"
#define FACE_CRY_ID 14
#define FACE_CRY_TEXT ":'("
#define FACE_CROSSEDLIPS_ID 15
#define FACE_CROSSEDLIPS_TEXT ":-X"
#define FACE_BIGSMILE_ID 16
#define FACE_BIGSMILE_TEXT ":-D"
#define FACE_LUKE_ID 18
#define FACE_LUKE_TEXT "C:-)"
	
#include <qvariant.h>
#include <qwidget.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QToolButton;

/**
 * A simply widget that shows all of the smilies that are available as
 * buttons.  When a button is clicked emits a signal with the corresponding
 * smiley number.  If the parent inherits KPopupMenu it will also then
 * close the parent.
 * @author Benjamin Meyer
 */
class Smilies : public QWidget
{ 
    Q_OBJECT

public:
  /// Constructor
  Smilies( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  /// Deconstructor
  ~Smilies();

signals:
  /// Emited when a smily is clicked.
  void smileyButtonClicked( int face );


protected:
  QToolButton* smile;
  QToolButton* angel;
  QToolButton* embarrassed;
  QToolButton* yell;
  QToolButton* wink;
  QToolButton* glasses;
  QToolButton* moneymouth;
  QToolButton* crossedlips;
  QToolButton* sad;
  QToolButton* scream;
  QToolButton* cry;
  QToolButton* burp;
  QToolButton* kiss;
  QToolButton* think;
  QToolButton* tongue;
  QToolButton* luke;
  QToolButton* bigsmile;
  QToolButton* oneeye;
  QGridLayout* SmiliesLayout;

private slots:
  void smileClicked();
  void angelClicked();
  void embarrassedClicked();
  void yellClicked();
  void winkClicked();
  void glassesClicked();
  void moneymouthClicked();
  void crossedlipsClicked();
  void sadClicked();
  void screamClicked();
  void cryClicked();
  void burpClicked();
  void kissClicked();
  void thinkClicked();
  void tongueClicked();
  void lukeClicked();
  void bigsmileClicked();
  void oneeyeClicked();

};

#endif 

// SMILIES_H

