/***************************************************************************
                               awaymessage.cpp
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "awaymessage.h"
#include <kiconloader.h>
#include <qdir.h>

/**
 * Initializes the dialog.  Copies sound settings from settings.
 * Connects signals.
 * @param parent the parent widget
 * @param name the name of the widget
 */
AwayMessage::AwayMessage(QWidget *parent, const char *name) : QWidget(parent,name){
  // Load image
  this->setIcon(SmallIcon("kinkatta"));
  // Create GUI
  initDialog();
  // Load setings
	/*
  i_aimSettings = aimSettings;
	*/
  
  i_aimSettings = setup::settings();
  // Initialize variables and GUI settings
  //message->setReadOnly(true);
  oldSoundSettings = i_aimSettings->SoundMode;
  if (i_aimSettings->away_disable_sound == true)
    no_sound->setChecked(true);
  // Connect button
  connect(message, SIGNAL(textChanged()), this, SLOT(textChanged())); 
  connect(Back, SIGNAL(clicked()), this, SLOT(back()));
  connect(Update, SIGNAL(clicked()), this, SLOT(updateClicked()));
  Update->setEnabled(false);
}

/**
 * Does nothing remarkable.
 */
AwayMessage::~AwayMessage(){
}

/**
 * Re-enables the Update button.
 */
void AwayMessage::textChanged(){
  Update->setEnabled(true);
}

/**
 * Initializes the dialog.
 */
void  AwayMessage::initDialog(){
  this->resize(280,215);
  message= new QMultiLineEdit(this,"NoName");
  message->setWordWrap (QMultiLineEdit::WidgetWidth );
  message->setGeometry(10,60,260,110);
  message->setMinimumSize(0,0);

  Back= new QPushButton(this,"NoName");
  
Back->setGeometry(170,180,100,25);
  Back->setMinimumSize(0,0);
  Back->setText("Back");

  Update= new QPushButton(this,"NoName");
  Update->setGeometry(110,180,60,25);
  Update->setMinimumSize(0,0);
  Update->setText("Update");
  Update->show();
	
	/*
  text1= new QLabel(this,"NoName");
  text1->setGeometry(10,10,260,20);
  text1->setMinimumSize(0,0);
  text1->setText(tr("The following message will be sent to anyone"));

  text2= new QLabel(this,"NoName");
  text2->setGeometry(10,30,230,20);
  text2->setMinimumSize(0,0);
  text2->setText(tr("that tries to IM you:"));
	*/

  no_sound= new QCheckBox(this,"NoName");
  no_sound->setGeometry(10,180,110,25);
  no_sound->setMinimumSize(0,0);
  no_sound->setText("Disable Sounds");
  no_sound->hide();

}

/**
 * Resizes the window according to e
 * @param e the resize event
 */
void AwayMessage::resizeEvent(QResizeEvent *){
  message->setGeometry(0, 5, this->width(), this->height()-40);
  Update->setGeometry(5, this->height()-30, 55, 25);
  Back->setGeometry(this->width()-50-5, this->height()-30, 50, 25);
  no_sound->setGeometry(10, 10 + this->height()-60 + 5, 110, 25);
}

/**
 * Toggles the away sound mode
 * @param on whether to disable sound
 */
void AwayMessage::toggle(bool on){
  if (on == true){
    // Set sound to nosound
    oldSoundSettings = i_aimSettings->SoundMode;
    i_aimSettings->SoundMode = 2;
  }
  else{
    // Set sound mode back to old setting
    i_aimSettings->SoundMode = oldSoundSettings;
    // Save chage in settings
    i_aimSettings->away_disable_sound = false;
  }
}

/**
 * @param text the new away message
 */
void AwayMessage::setText(QString text){
  message->clear();
  message->setText(text);
  Update->setEnabled(false);
}

/**
 * Restores the old sound settings.
 */
void AwayMessage::back(){
  i_aimSettings->SoundMode = oldSoundSettings;
  emit backClicked();
}

/**
 * Updates the away message
 */
void AwayMessage::updateClicked(){
  emit update(message->text());
  Update->setEnabled(false);
}


// awaymessage.cpp
#include "awaymessage.moc"
