/**************************************************************************
                            kinkattalistview.h
                            -------------------
    begin                : Fri Feb 15 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KINKATTALISTVIEW_H
#define KINKATTALISTVIEW_H

#include <qlineedit.h>
#include <klistview.h>
#include <qtooltip.h>
#include <qcursor.h>

class QEvent;
class QPainter;
class QColorGroup;
class QPoint;

/**
 * Structor used when passing tooltip information back and forth.
 */
struct toolTipData{
  /// Tooltip for the location at cords.
  QString tip;
  /// The cordinate for the tooltip tip.
  QRect cords;
};

/**
 * Font settings for the main window.
 * Used when a contact sighs on/off
 */
struct buddylist_Font_Settings{
  /// Font for when a contact is online.
  QFont buddylist_OnlineFont;
  /// Font for when a contact is offline.
  QFont buddylist_OfflineFont;
  /// Font for when a contact first signs on.
  QFont buddylist_SignOnFont;
};

/**
 * When you edit a contact this is what shows.  It is a QLineEdit embedded into
 * the ListBox.
 * @author Benjamin Meyer
 */
class EditBox : public QLineEdit {

Q_OBJECT

public:
  /// Constructor
  EditBox(QWidget *parent=0, const char *name=0);

  /// Current focus number.
  int focus;
  /// If this we are editing an alias.
  bool alias;

protected:	
  /// When the edit box losses focus it hides itself.
  void focusOutEvent ( QFocusEvent * );

};

/**
 * When you edit a contact this is what shows.  It is a QLineEdit embeded into
 * the ListBox.
 * @author Dimi Shahbaz
 */
class BuddyListWindowItem : public QListViewItem {

public:
  enum Decoration { Online, Offline, SignOn } ;
  
  /// Constuctor
  BuddyListWindowItem(KListView *, QString);
  /// Constuctor
  BuddyListWindowItem(QListViewItem *, QString);
  /// Real name of the contact. 
  QString name;

  /// Width of passed in paramiters.		
  int width( const QFontMetrics& , const KListView* , int ) const;
  
  /// There are new font settings for the mainWindow, get them.
  void updateFontSettings();
		
  /// Set the decoration type
  void setDecoration(int);

  /// Get the current decoration type
  int decoration();

  void paintCell(QPainter *, const QColorGroup &, int , int , int );

protected:
  int mDecoration;
  buddylist_Font_Settings *fontSettings;

};

/**
 * This allows for tooltips on contacts.  Overloads maybeTip to determine if
 * there is a tooltip where the mouse currently is.
 * @author Benjamin Meyer
 */
class DynamicTip : public QToolTip{

public:
  /// Constructor
  DynamicTip( QWidget * parent );

protected:
  /// Determines if a tooltip should show.
  void maybeTip( const QPoint & );

};

/**
 * Base class for the contact list.
 * @author Benjamin Meyer
 */
class KinkattaListView : public KListView {

Q_OBJECT

signals:
  /// Delete was pressed on the contact.
  void removeBuddy( QString contact );
  /// Delete was pressed on the folder.
  void removeFolder( QString folder );
  /// Move 'item' to folder 'newFolder'
  void moveItem( QListViewItem *item, QListViewItem *newFolder );

public:
  /// Constructor
  KinkattaListView(QWidget *parent=0, const char *name=0);
  /// Deconstructor
  ~KinkattaListView();

  /// Edit box that displays the text to edit.
  EditBox *buddyEdit;
  /// The item that this edit box goes to.
  BuddyListWindowItem *currentItem();
  /// The currentName that is being edited (i.e. before edited the name was)
  QString currentName();
  /// check if the item is a root item
  bool checkIfFolder(QListViewItem* selected);
  /// Generate a tooltip for this point in the list
  toolTipData tip( const QPoint & p );

private:
  /// The currently selected item (used for dragging)
  QListViewItem *currentSelectedItem;
  QCursor internalCursor;
  DynamicTip * t;

protected:
  void keyPressEvent(QKeyEvent *event);
  void contentsMouseReleaseEvent(QMouseEvent* event);
  void focusOutEvent( QFocusEvent * );

private slots:
  void itemPressed(QListViewItem *item);

};


#endif

// KinkattaViewList.h

