/***************************************************************************
                             kinkattaplugin.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTACOMBOPLUGIN_H
#define KINKATTACOMBOPLUGIN_H

#include <kinkattaplugin.h>
#include <qlist.h>
#include <qcombobox.h>
#include "plugincombobox.h"

class Chat;

/**
 * A combo-box manager.  This class will manage chat windows as they are
 * created and destroyed.  The combo-boxes are then available to be used.
 * @author Benjamin Meyer
 */
class KinkattaComboPlugin : public KinkattaPlugin {

Q_OBJECT
	
signals:

public:
  // Constructor.
  KinkattaComboPlugin(QWidget *parent=0, const char *name=0);
 
  /// Deconstructor.
  virtual ~KinkattaComboPlugin();

public slots:
  /// A message has come from the network for this plugin to handle.
  virtual void inChatMessage( QString buddy, QString message, bool isAuto );

  /// A message in going out for this plugin to handle.
  virtual void outChatMessage( QString buddy, QString message, bool isAuto, bool endIdleNess );

  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

private slots:
  /// A new chat window was created.
  virtual void chatWindowCreated( Chat *window );

  /// A chat window was destroyed.
  virtual void destroyingChatWindow( Chat *window );

protected:
  /// Chat windows that have been started.
  QList<Chat> windows;
  
  /// The combo boxes that have been started.
  QList<KinkattaComboBox> buttons;

};

#endif

// kinkattacomboplugin.h

