/***************************************************************************
                               buddytimecard.h
                             -------------------
    begin                : Sunday Jan 27 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTADEBUGWINDOW_H
#define KINKATTADEBUGWINDOW_H

#include <kinkattaplugin.h>

#include <qfile.h>
#include <qtextstream.h>
class Configure;

/**
 * This plugin will log buddies when the login and off.
 * @author Benjamin Meyer
 */

class BuddyTimeCard : public KinkattaPlugin {

Q_OBJECT
	
public:
  /// Constructor.
  BuddyTimeCard(QWidget *parent=0, const char *name=0);
 
  /// Deconstructor.
  ~BuddyTimeCard();

public slots:
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

  /// Get the configure widget for this plugin
  QWidget *configure( QWidget *parent );

  /// Get the settings from the configure widget and apply them.
  virtual void applyConfigure();

  /// When it is time to save settings this function is called.
  virtual void saveSettings();

private slots:
  /// Log this buddy as signing off
  void buddySignedOff( QString buddy );

  /// Log this buddy as signing on
  void buddySignedOn( QString buddy );

private:
  /// The Configure widget.
  Configure *configureWidget;

  /// If we are logging or not.
  bool loggingEnabled;
  
  /// Is there a log?
  bool logOpen;
  
  /// The file pointer to the open log
  QFile logFile;

  /// The file stream for the open log.
  QTextStream logStream;

};

#endif

// buddytimecard.h

