/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "commands.h"

#include <stdio.h>

struct navigate_control g_nav_ctl;
gboolean view_100_percent = FALSE;

void
on_main_window_show                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
	//kinoInitialise( widget );
}

gboolean
on_main_window_delete_event (GtkWidget *widget,
                             GdkEvent *event,
                             gpointer user_data)
{
	kinoDeactivate();
    return FALSE;
}

gboolean
on_main_window_key_press_event (GtkWidget *widget,
                                GdkEventKey *event,
                                gpointer user_data)
{
	// Process the keypress event with regard to the current 
	// notebook selection
	return processKeyboard( event );
}

gboolean
on_main_window_key_release_event       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	/* DRD> I had to comment out the following to prevent keybaord input
	   from interrupting AVC control. I changed page_editor.cc and page_capture.cc
	   to explicitly issue videoStop() with Esc. Seems to work fine.
	 */
//    if ( event->keyval != 0x00000020) /* spacebar = play/pause */
//        videoStop();
    return FALSE;
}

void
on_new_activate (GtkWidget *menuitem,
                 gpointer user_data)
{
	newFile( );
}


void
on_open_activate (GtkWidget *menuitem,
                  gpointer user_data)
{
	openFile( );
}


void
on_save_activate (GtkWidget *menuitem,
                  gpointer user_data)
{
    savePlayList( );
}


void
on_save_as_activate (GtkMenuItem *menuitem,
                     gpointer user_data)
{
	savePlayListAs( );
}


void
on_exit_activate (GtkWidget *menuitem,
                  gpointer user_data)
{
	kinoDeactivate();
}


void
on_undo_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
    /* empty body */
}


void
on_redo_activate (GtkMenuItem *menuitem,
                  gpointer user_data)
{
    /* empty body */
}


void
on_cut_current_frame_activate (GtkMenuItem *menuitem,
                               gpointer user_data)
{
	processMenuCommand( "x" );
}


void
on_cut_to_end_of_scene_activate (GtkMenuItem *menuitem,
                                    gpointer user_data)
{
	processMenuCommand( "d$" );
}


void
on_cut_current_scene_activate (GtkWidget *menuitem,
                                  gpointer user_data)
{
	processMenuCommand( "dd" );
}


void
on_copy_current_frame_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
	processMenuCommand( "yl" );
}


void
on_copy_current_scene_activate (GtkWidget *menuitem,
                                   gpointer user_data)
{
	processMenuCommand( "yy" );
}


void
on_paste_before_current_frame_activate (GtkWidget *menuitem,
                                        gpointer user_data)
{
	processMenuCommand( "P" );
}


void
on_paste_after_current_frame_activate (GtkWidget *menuitem,
                                       gpointer user_data)
{
	processMenuCommand( "p" );
}

void
on_insert_movie_activate (GtkWidget *menuitem,
                          gpointer user_data)
{
	insertFile();

}

void
on_save_frame_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	saveFrame( );
}


void
on_move_one_frame_forward_activate (GtkMenuItem *menuitem,
                                    gpointer user_data)
{
	processMenuCommand( "l" );
}

void
on_move_one_frame_backwards_activate (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
	processMenuCommand( "h" );
}

void
on_move_to_start_of_scene_activate (GtkMenuItem *menuitem,
                                       gpointer user_data)
{
	processMenuCommand( "0" );
}

void
on_move_to_end_of_scene_activate (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
	processMenuCommand( "$" );
}

void
on_move_to_start_of_next_scene_activate
(GtkMenuItem *menuitem,
 gpointer user_data)
{
	processMenuCommand( "j" );
}


void
on_move_to_start_of_previous_scene_activate
(GtkMenuItem *menuitem,
 gpointer user_data)
{
	processMenuCommand( "k" );
}


void
on_move_forward_one_second_activate (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
	processMenuCommand( "w" );
}


void
on_move_backwards_one_second_activate (GtkMenuItem *menuitem,
                                       gpointer user_data)
{
	processMenuCommand( "b" );
}


void
on_move_to_first_frame_activate (GtkMenuItem *menuitem,
                                 gpointer user_data)
{
	processMenuCommand( "gg" );
}


void
on_move_to_last_frame_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
    processMenuCommand( "G" );
}

gboolean
on_video_drawingarea1_expose_event (GtkWidget *widget,
                                    GdkEventExpose *event,
                                    gpointer user_data)
{
	refresh( );
    return FALSE;
}

void
on_about_activate                      (GtkWidget     *menuitem,
                                        gpointer         user_data)
{
    gtk_widget_show( create_about_window() );
}


gboolean
on_about_window_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(widget);
    gtk_widget_destroy(dialog);
    return FALSE;
}


void
on_show_frame_cancel_pressed           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    gtk_widget_destroy(dialog);
}

gboolean handleframepos = FALSE;

gboolean
on_frame_pos_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  	handleframepos = TRUE;
  	return FALSE;
}


gboolean
on_frame_pos_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  	handleframepos = FALSE;
  	return FALSE;
}

gboolean
on_frame_pos_value_changed_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if ( handleframepos ) {
		moveToFrame( GTK_ADJUSTMENT(widget)->value );
	}
  	return FALSE;
}


gboolean
on_command_focus_in_event              (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
	gtk_entry_set_editable( GTK_ENTRY( widget ), TRUE );
	g_nav_ctl.escaped = TRUE;
  	return FALSE;
}


gboolean
on_command_focus_out_event             (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{

	gtk_entry_set_editable( GTK_ENTRY( widget ), FALSE );
	g_nav_ctl.escaped = FALSE;
  	return FALSE;
}


void
on_command_grab_focus                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	gtk_entry_set_editable( GTK_ENTRY( widget ), TRUE );
	g_nav_ctl.escaped = TRUE;
}


void
on_command_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	gchar *cmd = gtk_entry_get_text( GTK_ENTRY( editable ) );
	processCommandLine( cmd );
}


void
on_main_notebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	pageStart( page_num );
}


void
on_iconlist2_select_icon               (GnomeIconList   *gnomeiconlist,
                                        gint             arg1,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	selectScene( arg1 );
}


void
on_video_start_movie_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	videoStart( );
}


void
on_video_start_scene_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	videoPreviousScene( );
}


void
on_video_rewind_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	videoRewind( );
}


void
on_video_back_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	videoBack( );
}


void
on_video_play_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	videoPlay( );
}


void
on_video_forward_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	videoForward( );
}


void
on_video_fast_forward_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	videoFastForward( );
}


void
on_video_end_scene_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	videoNextScene( );
}


void
on_video_end_movie_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	videoEndOfMovie( );
}


void
on_video_pause_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	videoPause( );
}


void
on_video_stop_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	videoStop( );
}


void
on_editor_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	notebookChangePage( 0 );
}


void
on_capture_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	notebookChangePage( 1 );
}


void
on_timeline_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	notebookChangePage( 2 );
}


gboolean
on_drawingarea2_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	RefreshBar( lookup_widget( widget, "frame_pos" ) );
  return FALSE;
}


void
on_drawingarea2_size_allocate          (GtkWidget       *widget,
                                        GtkAllocation   *allocation,
                                        gpointer         user_data)
{
	RefreshBar( lookup_widget( widget, "frame_pos" ) );
}

gboolean
on_eventbox1_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	g_nav_ctl.escaped = FALSE;
	gtk_entry_set_editable( GTK_ENTRY(lookup_widget( widget, "command" )), FALSE );
	gtk_widget_grab_focus( widget );
  return FALSE;
}


gboolean
on_command_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	g_nav_ctl.escaped = TRUE;
	gtk_entry_set_editable( GTK_ENTRY(lookup_widget( widget, "command" )), TRUE );
  return FALSE;
}



void
on_v4l_start_capture_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_v4l_stop_capture_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_main_window_size_allocate           (GtkWidget       *widget,
                                        GtkAllocation   *allocation,
                                        gpointer         user_data)
{
	windowChanged();
}

gboolean
on_main_window_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
	windowMoved();
  	return FALSE;
}


gboolean
on_main_window_visibility_notify_event (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  	return FALSE;
}


gboolean
on_main_window_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	printf( ">> Event = %d\n", event->type );
	//visibilityChanged();
  return FALSE;
}


gboolean
on_main_window_map_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

	visibilityChanged( TRUE );
  	return FALSE;
}


gboolean
on_main_window_unmap_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	visibilityChanged( FALSE );
  	return FALSE;
}


void
on_export_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	notebookChangePage( 3 );

}


void
on_50percent_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ((GtkCheckMenuItem *) menuitem)->active )
		view50percent();
	view_100_percent = FALSE;
}


void
on_100percent_activate                 (GtkWidget     *menuitem,
                                        gpointer         user_data)
{
	if ( ((GtkCheckMenuItem *) menuitem)->active )
		view100percent();
	view_100_percent = TRUE;
}


void
on_hscale_shuttle_value_changed_event  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	videoShuttle( GTK_ADJUSTMENT(widget)->value );
}

gboolean
on_hscale_shuttle_button_release_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	/* "snap" the widget back to center */
	gtk_adjustment_set_value( GTK_RANGE(widget)->adjustment, 0 );
	return FALSE;
}

gboolean
on_showinfo_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	printf( "Show info request registered\n" );
	toggleShowInfo();
  	return FALSE;
}


gboolean
on_eventbox_capture_drawingarea_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	g_nav_ctl.escaped = FALSE;
	gtk_entry_set_editable( GTK_ENTRY(lookup_widget( widget, "capture_page_file_entry" )), FALSE );
	gtk_widget_grab_focus( widget );
  return FALSE;
}



void
on_append_movie_activate               (GtkWidget     *menuitem,
                                        gpointer         user_data)
{
	appendFile();
}


void
on_split_scene_activate                (GtkWidget     *menuitem,
                                        gpointer         user_data)
{
	processCommandLine(":split");
}


void
on_button_viewsize_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( view_100_percent == FALSE ) {
		view100percent();
		view_100_percent = TRUE;
	} else {
		view50percent();
		view_100_percent = FALSE;
	}
}

void
on_help_topics_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *tmp;
	tmp = gnome_help_file_find_file ("kino", "index.html");
	if (tmp) {
		gnome_help_goto(0, tmp);
		g_free(tmp);
	}  
}

