
#ifndef _LIBDV_WRAPPER
#define _LIBDV_WRAPPER

#include <libdv/dv.h>
#include <pthread.h>

/** Static wrapping for the libdv API. It allows configurable mutex usage on each
	API to avoid non-threadsafe coding issues.

	The lock and unlock are deliberately inline.
*/

class LibDV {
	private:
		static pthread_mutex_t mutex;

		static void lock() {
			pthread_mutex_lock( &mutex );
		}

		static void unlock() {
			pthread_mutex_unlock( &mutex );
		}

	public:
		static dv_decoder_t *DV_decoder_new();
		static void DV_init( );
		static gint DV_parse_header( dv_decoder_t *dv, guchar *buffer );
		static void DV_decode_full_frame( dv_decoder_t *dv, 
					  	guchar *buffer, dv_color_space_t color_space, 
					  	guchar **pixels, gint *pitches );
		static gint DV_decode_full_audio(dv_decoder_t *dv, 
					  	guchar *buffer, gint16 **outbufs);
		static void DV_decode_video_segment(dv_decoder_t *dv, 
						dv_videosegment_t *seg, guint quality );
		static void DV_render_video_segment_rgb(dv_decoder_t *dv, 
						dv_videosegment_t *seg, 
						guchar **pixels, gint *pitches);
		static void DV_render_video_segment_yuv(dv_decoder_t *dv, 
						dv_videosegment_t *seg, 
						guchar **pixels, gint *pitches);
		static int DV_frame_changed (dv_decoder_t *dv);
	   	static int DV_frame_is_color (dv_decoder_t *dv);
	   	static int DV_system_50_fields (dv_decoder_t *dv);
	   	static int DV_format_normal (dv_decoder_t *dv);
	   	static int DV_format_wide (dv_decoder_t *dv);
	   	static int DV_get_vaux_pack (dv_decoder_t *dv, 
						guint8 pack_id, guint8 *pack_data);
};

#endif
