/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "commands.h"

GtkWidget *main_window ;

int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
#endif

    g_thread_init(NULL);
    gnome_init ("kino", VERSION, argc, argv);
    gdk_rgb_init();
    main_window = create_main_window ();
	kinoInitialise( main_window );
    gtk_widget_set_events( main_window, GDK_KEY_RELEASE_MASK);
    gtk_widget_show (main_window);
    windowChanged();
    bulkLoad(argc, argv);
    
    gdk_threads_enter();
    gtk_main ();
    gdk_threads_leave();
    return 0;
}

